/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PageRanges;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.config.IConfigModel;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;
import kd.bos.print.core.ctrl.print.config.PrintJobConfig;
import kd.bos.print.core.ctrl.print.config.attribute.PageRangeInfo;
import kd.bos.print.core.ctrl.print.config.ui.AbstractStartLocationModel;
import kd.bos.print.core.ctrl.print.config.ui.PaperAdjustModel;
import kd.bos.print.core.ctrl.print.config.ui.PaperStartLocationModel;
import kd.bos.print.core.ctrl.print.config.ui.PrintConfigModel;
import kd.bos.print.core.ctrl.print.config.xml.PrinterConfigXml;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;

public class ConfigManager
implements IConfigModel {
    private KDPrinter printer;
    private PrintConfigModel model = new PrintConfigModel();
    private Map configPanes;
    private ArrayList configNameList;
    boolean isChange = false;
    private PaperAdjustModel paperAdjustModel = new PaperAdjustModel();
    private AbstractStartLocationModel paperStartModel = new PaperStartLocationModel();
    private String printJobName = "Kingdee printing";

    public ConfigManager(KDPrinter printer) {
        this.printer = printer;
        this.configPanes = new LinkedHashMap();
        this.configNameList = new ArrayList();
        this.init();
    }

    private void init() {
    }

    public KDPrinter getPrinter() {
        return this.printer;
    }

    public PrintConfigModel getModel() {
        return this.model;
    }

    public List getConfigNameList() {
        return this.configNameList;
    }

    public Class getConfigPanel(String name) {
        return (Class)this.configPanes.get(name);
    }

    public void registerConfigUI(String name, Class class1) {
        Class previous = this.configPanes.put(name, class1);
        if (previous == null) {
            this.configNameList.add(name);
        }
    }

    public void registerConfigUI(String name, Class class1, int position) {
        Class previous = this.configPanes.put(name, class1);
        if (previous == null) {
            if (this.configNameList.size() > position) {
                this.configNameList.add(position, name);
            } else {
                this.configNameList.add(name);
            }
        }
    }

    public void unRegisterConfigUI(String name) {
        this.configPanes.remove(name);
        int length = this.configNameList.size();
        for (int i = 0; i < length; ++i) {
            String configname = (String)this.configNameList.get(i);
            if (!configname.equals(name)) continue;
            this.configNameList.remove(i);
            break;
        }
    }

    public PrintService getPrintService() {
        return this.model.getPrintService();
    }

    public void setPrintService(PrintService printService) {
        this.model.setPrintService(printService);
    }

    public PrintJobConfig[] getJobsConfigs() {
        return this.printer.getPrintJob().getJobsConfigs();
    }

    public PrintJobConfig getJobConfig(String id) {
        PrintJobConfig[] pjcs = this.getJobsConfigs();
        if (pjcs != null) {
            for (int i = pjcs.length - 1; i >= 0; --i) {
                if (!pjcs[i].getID().equals(id)) continue;
                return pjcs[i];
            }
        }
        return null;
    }

    public PrintRequestAttributeSet buildPrintRequAttrSet() {
        PrintRequestAttributeSet attriSet = null;
        if (this.model.hasOddEvenPageRange()) {
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet(this.model.getPrintRequestAttributeSet());
            this.parseOddEven(aset);
            attriSet = aset;
        } else {
            attriSet = this.model.getPrintRequestAttributeSet();
        }
        PrintRequestAttributeSet pset = this.printer.getPrintJobByPaperIndex(0).getConfig().getPrintRequestAttributeSet();
        attriSet.addAll(pset);
        attriSet.add(new JobName(this.printJobName, null));
        return attriSet;
    }

    public void setPageRanges(String numberStr) {
        PrintRequestAttributeSet set = this.model.getPrintRequestAttributeSet();
        if (numberStr != null && !numberStr.equals("")) {
            PageRanges pageRanges = new PageRanges(numberStr);
            set.add(pageRanges);
        }
    }

    private void parseOddEven(PrintRequestAttributeSet printset) {
        PageRanges oldRange = (PageRanges)printset.get(PageRanges.class);
        PageRangeInfo pageRangeInfo = (PageRangeInfo)printset.get(PageRangeInfo.class);
        short oddEvenValue = (short)Integer.parseInt((String)pageRangeInfo.getRageRanges());
        String numberStr = KDPrinterUtils.buildOddEvenNumberStr(this.printer.getPrintJob().getPageCount(), oddEvenValue == 6, oldRange);
        if (numberStr != null && !numberStr.equals("")) {
            PageRanges pageRanges = new PageRanges(numberStr);
            printset.add(pageRanges);
        }
    }

    public void setPrintJobName(String jobName) {
        this.printJobName = jobName;
    }

    public String getPrintJobName() {
        return this.printJobName;
    }

    public void setChange(boolean ischange) {
        this.isChange = ischange;
    }

    public boolean isChange() {
        return this.isChange;
    }

    public void checkChange() {
        if (this.isChange()) {
            this.printer.getPrintJob().rePagination();
        }
    }

    public int getEncode() {
        return this.model.getEncode();
    }

    public void clear() {
        this.configPanes.clear();
        this.init();
    }

    public PaperAdjustModel getAdjustor() {
        return this.paperAdjustModel;
    }

    public AbstractStartLocationModel getStartLocationModel() {
        return this.paperStartModel;
    }

    public void setStartLocationModel(AbstractStartLocationModel paperStartModel) {
        this.paperStartModel = paperStartModel;
    }

    public static String getMsg(String key) {
        return null;
    }

    @Override
    public void installManager(PrintJobConfig manager) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefault() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return new PrinterConfigXml(this);
    }

    @Override
    public String getID() {
        return this.printer.getID();
    }

    @Override
    public void set(IConfigModel from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object copy() {
        throw new UnsupportedOperationException();
    }
}

