/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.print.PrintService;
import javax.swing.event.EventListenerList;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.print.ConfigManager;
import kd.bos.print.core.ctrl.print.DefaultVariantParser;
import kd.bos.print.core.ctrl.print.IPrintActionListener;
import kd.bos.print.core.ctrl.print.IVariantParser;
import kd.bos.print.core.ctrl.print.KDPConstant;
import kd.bos.print.core.ctrl.print.config.IConfigModel;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;
import kd.bos.print.core.ctrl.print.config.PrintJobConfig;
import kd.bos.print.core.ctrl.print.config.ui.PageSetupModel;
import kd.bos.print.core.ctrl.print.control.ControlPrint;
import kd.bos.print.core.ctrl.print.io.IOManager;
import kd.bos.print.core.ctrl.print.printjob.IPrintJob;
import kd.bos.print.core.ctrl.print.printjob.MultiBufferPrintJobs;
import kd.bos.print.core.ctrl.print.util.TempFileUtil;
import kd.bos.print.core.model.ui.IPaintFilter;
import kd.bos.print.core.model.ui.component.MixVariantLabelCell;

public class KDPrinter
implements KDPConstant {
    private static final Log log = LogFactory.getLog(KDPrinter.class);
    private IPrintJob printJob;
    private static Map painterXmlTranslateMap;
    private static volatile boolean FIRST_LOAD;
    private ControlPrint controlPrint;
    private ConfigManager config;
    private IVariantParser defaultVariantParser;
    private IVariantParser variantParser;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean isStopPaginationField = false;
    private boolean isDividePageField = false;
    private IPaintFilter paintFilter;
    private IOManager ioManager;
    private boolean isExportImportButtonVisibleField = false;
    private boolean isEditButtonVisibleField = false;
    private static String[] headFootPreList;
    private WaterMark waterMark;

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
    }

    public KDPrinter() {
        this.controlPrint = new ControlPrint(this);
        this.config = new ConfigManager(this);
        this.printJob = new MultiBufferPrintJobs();
        this.printJob.setPrinter(this);
    }

    public void setPrintConfig(ConfigManager config) {
        this.config = config;
    }

    public ConfigManager getPrintConfig() {
        return this.config;
    }

    public ControlPrint getControlPrint() {
        return this.controlPrint;
    }

    public IPrintJob getPrintJob() {
        return this.printJob;
    }

    public PrintService getPrintService() {
        return this.config.getPrintService();
    }

    public void printDirect() {
        if (this.preParePrint()) {
            this.controlPrint.print(this.getPrintJob());
        } else {
            this.config.getModel().reset();
        }
    }

    public boolean preParePrint() {
        boolean hasContent = this.hasPrintContent();
        if (hasContent) {
            this.getPrintJob().preparePagination();
        }
        return hasContent;
    }

    private boolean hasPrintContent() {
        boolean hasContent = false;
        IPrintJob job = this.getPrintJob();
        if (job != null) {
            boolean bl = hasContent = !job.isEmpty();
        }
        if (!hasContent) {
            // empty if block
        }
        return hasContent;
    }

    private IConfigModel getModel() {
        PrintJobConfig printJobConfig = this.getPrintJob().getConfig();
        if (printJobConfig == null) {
            printJobConfig = this.config.getJobsConfigs()[0];
        }
        return null;
    }

    private void setWaterMark(String mark, IConfigModel model) {
        if (model instanceof PageSetupModel) {
            MixVariantLabelCell waterMark = null;
            waterMark = ((PageSetupModel)model).getWaterMark() != null ? ((PageSetupModel)model).getWaterMark() : new MixVariantLabelCell();
            waterMark.setText(mark + "     ");
            waterMark.setStyle(PageSetupModel.WATERMARK_DEFAULTSTYLE);
            ((PageSetupModel)model).setWaterMark(waterMark);
            if (this.getPrintJob() != null && this.getPrintJob().getConfig() != null) {
                this.getPrintJob().getConfig().setChange(true);
            }
        }
    }

    public void clear() {
        this.getPrintConfig().clear();
        this.printJob.clear();
        if (FIRST_LOAD) {
            TempFileUtil.deleteTempFile();
            FIRST_LOAD = false;
        }
    }

    public void addPrintJob(IPrintJob job) {
        this.printJob.addPrintJob(job);
    }

    public void setPrintJob(IPrintJob job) {
        this.clear();
        job.setPrinter(this);
        this.printJob = job;
    }

    public IPrintJob getPrintJobByPaperIndex(int paperIndex) {
        return this.printJob.getPrintJobByPaperIndex(paperIndex);
    }

    public IVariantParser getVariantParser() {
        return this.variantParser;
    }

    public void setVariantParser(IVariantParser variantParser) {
        this.variantParser = variantParser;
    }

    public IVariantParser getDefaultVariantParser() {
        if (this.defaultVariantParser == null) {
            this.defaultVariantParser = new DefaultVariantParser();
        }
        return this.defaultVariantParser;
    }

    public void setDefaultVariantParser(IVariantParser defaultVariantParser) {
        this.defaultVariantParser = defaultVariantParser;
    }

    public String getID() {
        return null;
    }

    public static IXmlTranslate getPainterXmlTranslate(String name) {
        if (painterXmlTranslateMap != null) {
            return (IXmlTranslate)painterXmlTranslateMap.get(name);
        }
        return null;
    }

    public static synchronized void registerPainterXmlTranslate(String name, IXmlTranslate trans) {
        if (painterXmlTranslateMap == null) {
            painterXmlTranslateMap = new HashMap(1);
        }
        painterXmlTranslateMap.put(name, trans);
    }

    public void addPreviewActionListener(IPrintActionListener lisener) {
        this.addListener(IPrintActionListener.class, lisener);
    }

    private void addListener(Class listenerClass, EventListener lisener) {
        if (lisener == null) {
            return;
        }
        this.listenerList.add(listenerClass, lisener);
    }

    public boolean isStopPagination() {
        return this.isStopPaginationField;
    }

    public boolean isDynamicPaper() {
        return this.config.getModel().isDynamicPaper();
    }

    public void setDynamicPaper(boolean isDynamicpaper) {
        this.config.getModel().setDynamicPaper(isDynamicpaper);
    }

    public String[] getHeadFootPreList() {
        return headFootPreList;
    }

    public IPaintFilter getPaintFilter() {
        return this.paintFilter;
    }

    public void setPaintFilter(IPaintFilter paintFilter) {
        this.paintFilter = paintFilter;
    }

    public IOManager getIOManager() {
        if (this.ioManager == null) {
            this.ioManager = new IOManager(this);
        }
        return this.ioManager;
    }

    public boolean isDividePage() {
        return this.isDividePageField;
    }

    static {
        FIRST_LOAD = true;
        headFootPreList = null;
        headFootPreList = new String[2];
        KDPrinter.headFootPreList[0] = "";
        KDPrinter.headFootPreList[1] = "&[Date] &[Time]";
    }
}

