/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JPanel;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.config.IConfigModel;
import kd.bos.print.core.ctrl.print.config.IConfigUI;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;
import kd.bos.print.core.ctrl.print.config.PrintJobConfigXml;
import kd.bos.print.core.ctrl.print.config.attribute.HeadFootIntervalInfo;
import kd.bos.print.core.ctrl.print.config.attribute.PageIntervalInfo;
import kd.bos.print.core.ctrl.print.config.ui.HeaderFooterModel;
import kd.bos.print.core.ctrl.print.config.ui.PageSetupModel;
import kd.bos.print.core.ctrl.print.config.ui.PaperAdjustModel;
import kd.bos.print.core.ctrl.print.printjob.IPrintJob;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;
import kd.bos.print.core.model.ui.component.Canvas;

public class PrintJobConfig
implements IConfigModel {
    protected IPrintJob printJob;
    private String headerFooterModelName = this.getMsg("tree.headerfooter");
    private boolean isDynamicPaperField = false;
    private Map<String, OneConfigPage> configPanes;
    private boolean isChangeField = false;
    private String[] headFootPreList;
    KDPrinter printer;
    private Map<String, IConfigModel> modelCache = new HashMap<String, IConfigModel>();
    private boolean pageMarginPanelVisible = true;

    public PrintJobConfig(IPrintJob printJob, KDPrinter printer) {
        this.printJob = printJob;
        this.printer = printer;
        this.configPanes = new LinkedHashMap<String, OneConfigPage>();
        this.headFootPreList = printer.getHeadFootPreList();
        this.init();
    }

    private void init() {
        List list = this.printer.getPrintConfig().getConfigNameList();
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            String key = (String)list.get(i);
            this.configPanes.put(key, new OneConfigPage(key, null));
        }
    }

    public void setPrintJob(IPrintJob job) {
        this.printJob = job;
    }

    private String getMsg(String key) {
        return null;
    }

    public IPrintJob getPrintJob() {
        return this.printJob;
    }

    public String getHeaderFooterNodelName() {
        return this.headerFooterModelName;
    }

    public IConfigModel getConfig(String name) {
        return this.modelCache.get(name);
    }

    public PageSetupModel getPageSetupModel() {
        PageSetupModel model = (PageSetupModel)this.getConfig(PageSetupModel.class.getSimpleName());
        if (model == null) {
            model = new PageSetupModel();
            this.setConfig(PageSetupModel.class.getSimpleName(), model);
        }
        return model;
    }

    public HeaderFooterModel getHeaderFooterModel() {
        HeaderFooterModel model = (HeaderFooterModel)this.getConfig(HeaderFooterModel.class.getSimpleName());
        if (model == null) {
            model = new HeaderFooterModel(this);
            this.setConfig(HeaderFooterModel.class.getSimpleName(), model);
        }
        return model;
    }

    public Map<String, OneConfigPage> getConfigPanes() {
        return this.configPanes;
    }

    public void setConfig(String uniqueName, IConfigModel config) {
        this.modelCache.put(uniqueName, config);
    }

    public void registerConfigUI(String uniqueName, OneConfigPage config) {
        this.configPanes.put(uniqueName, config);
    }

    public JPanel createPanelByName(String name) {
        OneConfigPage configPage = this.configPanes.get(name);
        JPanel panel = configPage.createPanel();
        return panel;
    }

    public DocAttributeSet getDocAttributeSet() {
        PageSetupModel model = this.getPageSetupModel();
        if (model != null) {
            return model.getDocAttributeSet();
        }
        return new HashDocAttributeSet();
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.getPageSetupModel().getPrintRequestAttributeSet();
    }

    public void addAttribute(Attribute attri) {
        if (attri == null) {
            return;
        }
        Class<? extends Attribute> cate = attri.getCategory();
        if (cate != PageRanges.class && cate != Copies.class) {
            this.getPrintRequestAttributeSet().add(attri);
        }
    }

    public PrintService getPrintService() {
        return this.printer.getPrintService();
    }

    public PaperAdjustModel getAdjustor() {
        return this.printer.getPrintConfig().getAdjustor();
    }

    public void clear() {
        if (this.getPageSetupModel() != null) {
            this.getPageSetupModel().clear();
        }
    }

    public String toString() {
        return "Print Attribute Manager ";
    }

    public void setChange(boolean ischange) {
        this.isChangeField = ischange;
        if (ischange) {
            this.printer.getPrintConfig().setChange(true);
        }
    }

    public void change(boolean ischange) {
        if (ischange) {
            this.setChange(true);
        }
    }

    public boolean isChange() {
        return this.isChangeField;
    }

    public float getLeftMargin(int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        return pageInfo.getLeft(unit);
    }

    public float getRightMargin(int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        return pageInfo.getRight(unit);
    }

    public float getBodyTopMargin(int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        return pageInfo.getTop(unit);
    }

    public void setBodyTopMargin(float margin, int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        pageInfo.setTop(margin, unit);
        this.updateMarginAttribute(pageInfo);
    }

    public float getBodyBottomMargin(int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        return pageInfo.getBottom(unit);
    }

    public float getHeaderMargin(int unit) {
        HeadFootIntervalInfo pageInfo = KDPrinterUtils.getHeadFootIntervalInfo(this.getPrintRequestAttributeSet());
        return pageInfo.getHeadTop(unit);
    }

    public float getFooterMargin(int unit) {
        HeadFootIntervalInfo pageInfo = KDPrinterUtils.getHeadFootIntervalInfo(this.getPrintRequestAttributeSet());
        return pageInfo.getFootBottom(unit);
    }

    public void setBodyBottomMargin(float margin, int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        pageInfo.setBottom(margin, unit);
        this.updateMarginAttribute(pageInfo);
    }

    public void setLeftMargin(float margin, int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        pageInfo.setLeft(margin, unit);
        this.updateMarginAttribute(pageInfo);
    }

    public void setRightMargin(float margin, int unit) {
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea(this.getPrintRequestAttributeSet());
        pageInfo.setRight(margin, unit);
        this.updateMarginAttribute(pageInfo);
    }

    public void setHeaderMargin(float margin, int unit) {
        HeadFootIntervalInfo hfi = KDPrinterUtils.getHeadFootIntervalInfo(this.getPrintRequestAttributeSet());
        hfi.setHeadTop(margin, unit);
        this.updateMarginAttribute(hfi);
    }

    public void setFooterMargin(float margin, int unit) {
        HeadFootIntervalInfo hfi = KDPrinterUtils.getHeadFootIntervalInfo(this.getPrintRequestAttributeSet());
        hfi.setFootBottom(margin, unit);
        this.updateMarginAttribute(hfi);
    }

    private void updateMarginAttribute(Attribute att) {
        this.getPrintRequestAttributeSet().add(att);
        this.setChange(true);
        this.printJob.checkChange();
    }

    public boolean isFrugalPrint() {
        if (this.getPageSetupModel() != null) {
            return this.getPageSetupModel().isFrugalPrint();
        }
        return false;
    }

    @Override
    public void installManager(PrintJobConfig manager) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return new PrintJobConfigXml(this);
    }

    @Override
    public void setDefault() {
        throw new UnsupportedOperationException();
    }

    public KDPrinter getPrinter() {
        return this.printer;
    }

    @Override
    public String getID() {
        return this.printJob.getID();
    }

    @Override
    public void set(IConfigModel model) {
        this.setChange(true);
        PrintJobConfig printAttrManager = (PrintJobConfig)model;
        Object[] keys = this.configPanes.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            IConfigModel from = printAttrManager.getConfig(key);
            if (from == null) continue;
            IConfigModel to = this.getConfig(key);
            if (to != null) {
                to.set(from);
                continue;
            }
            this.setConfig(key, (IConfigModel)from.copy());
        }
    }

    @Override
    public Object copy() {
        throw new UnsupportedOperationException("PrintAttributeManager can't clone");
    }

    public Canvas getHeader() {
        HeaderFooterModel model = this.getHeaderFooterModel();
        if (model != null) {
            return model.getHeader();
        }
        return null;
    }

    public Canvas getFooter() {
        HeaderFooterModel model = this.getHeaderFooterModel();
        if (model != null) {
            return model.getFooter();
        }
        return null;
    }

    public boolean isDynamicPaper() {
        return this.isDynamicPaperField;
    }

    public void setDynamicPaper(boolean isDynamicpaper) {
        this.isDynamicPaperField = isDynamicpaper;
    }

    public String[] getHeadFootPreList() {
        return this.headFootPreList;
    }

    public int getFooterAlign() {
        return this.getPageSetupModel().getFooterAlign();
    }

    public int getHeaderAlign() {
        return this.getPageSetupModel().getHeaderAlign();
    }

    @Deprecated
    public float getPageAdjustX() {
        return this.getPageSetupModel().getPageAdjustX();
    }

    @Deprecated
    public float getPageAdjustY() {
        return this.getPageSetupModel().getPageAdjustY();
    }

    public void setConfigPanesVisible(String name, boolean isVisible) {
    }

    public boolean isPageMarginPanelVisible() {
        return this.pageMarginPanelVisible;
    }

    public void setPageMarginPanelVisible(boolean pageMarginPanelVisible) {
        this.pageMarginPanelVisible = pageMarginPanelVisible;
    }

    public class OneConfigPage {
        private String key;
        private IConfigModel configMode;
        private boolean isVisible;

        public OneConfigPage(String panelclass, IConfigModel model) {
            this.key = panelclass;
            this.configMode = model;
            this.isVisible = true;
        }

        public JPanel createPanel() {
            JPanel panel = null;
            try {
                Class pClass = PrintJobConfig.this.printer.getPrintConfig().getConfigPanel(this.key);
                if (pClass != null) {
                    Object obj = null;
                    obj = pClass.newInstance();
                    panel = obj;
                }
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("panelclass not extend JPanel", e);
            }
            catch (IllegalAccessException ee) {
                throw new IllegalArgumentException("panelclass not extend JPanel", ee);
            }
            return panel;
        }

        public IConfigModel getConfigModel() {
            return this.configMode;
        }

        public void setConfigModel(IConfigModel configMode) {
            this.configMode = configMode;
        }

        public void createModel() {
            IConfigUI ui = (IConfigUI)((Object)this.createPanel());
            this.setConfigModel(ui.createConfigModel());
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean isVisible) {
            this.isVisible = isVisible;
        }
    }
}

