/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.config.attribute;

import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintRequestAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;

public class PageIntervalInfo
implements PrintRequestAttribute,
DocAttribute,
IXmlTranslate {
    private static final long serialVersionUID = 1410624698930255332L;
    private float top = 0.0f;
    private float left = 0.0f;
    private float bottom = 0.0f;
    private float right = 0.0f;
    public static final String NAME = "papermargin";
    public static final int INCH = 25400;
    public static final int MM = 1000;
    private static final Log log = LogFactory.getLog(PageIntervalInfo.class);

    public PageIntervalInfo() {
    }

    public PageIntervalInfo(float pTop, float pLeft, float pBottom, float pRight, int pUnits) {
        if ((double)pTop < 0.0 || (double)pLeft < 0.0 || (double)pBottom < 0.0 || (double)pRight < 0.0 || pUnits < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.top = pTop * (float)pUnits;
        this.left = pLeft * (float)pUnits;
        this.bottom = pBottom * (float)pUnits;
        this.right = pRight * (float)pUnits;
    }

    public static PageIntervalInfo getDefault() {
        return new PageIntervalInfo(25.0f, 19.0f, 25.0f, 19.0f, 1000);
    }

    public float getTop(int unit) {
        return PageIntervalInfo.convertFromMicrometers(this.top, unit);
    }

    public void setTop(float ptop, int unit) {
        this.top = ptop * (float)unit;
    }

    public void setLeft(float theleft, int unit) {
        this.left = theleft * (float)unit;
    }

    public void setRight(float theright, int unit) {
        this.right = theright * (float)unit;
    }

    public float getLeft(int unit) {
        return PageIntervalInfo.convertFromMicrometers(this.left, unit);
    }

    public float getBottom(int unit) {
        return PageIntervalInfo.convertFromMicrometers(this.bottom, unit);
    }

    public void setBottom(float pBottom, int unit) {
        this.bottom = pBottom * (float)unit;
    }

    public float getRight(int unit) {
        return PageIntervalInfo.convertFromMicrometers(this.right, unit);
    }

    public Class getCategory() {
        return PageIntervalInfo.class;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public float[] getPrintableArea(int units) {
        return new float[]{this.getTop(units), this.getLeft(units), this.getBottom(units), this.getRight(units)};
    }

    public String toString(int units, String unitsName) {
        if (unitsName == null) {
            unitsName = "";
        }
        float[] vals = this.getPrintableArea(units);
        String str = "(" + vals[0] + "," + vals[1] + ")->(" + vals[2] + "," + vals[3] + ")";
        return str + unitsName;
    }

    public boolean equals(Object object) {
        boolean ret = false;
        if (object instanceof PageIntervalInfo) {
            PageIntervalInfo mm = (PageIntervalInfo)object;
            if (this.top == mm.top && this.left == mm.left && this.bottom == mm.bottom && this.right == mm.right) {
                ret = true;
            }
        }
        return ret;
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public int hashCode() {
        return (int)(this.top + 37.0f * this.right + 43.0f * this.bottom + 47.0f * this.right);
    }

    private static float convertFromMicrometers(float v, int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return v / (float)units;
    }
}

