/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.config.attribute;

import javax.print.attribute.PrintRequestAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.print.config.AbstractXmlTranslate;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;
import org.dom4j.Element;

public class ValidateAreaInfo
implements PrintRequestAttribute,
IXmlTranslate {
    private static final long serialVersionUID = -1875885047427733603L;
    private float top;
    private float left;
    private float bottom;
    private float right;
    public static final String NAME = "ValideAreaInfo";
    public static final int INCH = 25400;
    public static final int MM = 1000;
    public static final ValidateAreaInfo DEFAULT = new ValidateAreaInfo(0.3f, 0.3f, 0.3f, 0.3f, 1000);
    private static final Log log = LogFactory.getLog(ValidateAreaInfo.class);

    public ValidateAreaInfo(float pTop, float pLeft, float pBottom, float pRight, int pUnits) {
        if ((double)pTop < 0.0 || (double)pLeft < 0.0 || (double)pBottom <= 0.0 || (double)pRight <= 0.0 || pUnits < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.top = pTop * (float)pUnits;
        this.left = pLeft * (float)pUnits;
        this.bottom = pBottom * (float)pUnits;
        this.right = pRight * (float)pUnits;
    }

    public float getTop(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.top, unit);
    }

    public float getLeft(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.left, unit);
    }

    public float getBottom(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.bottom, unit);
    }

    public float getRight(int unit) {
        return ValidateAreaInfo.convertFromMicrometers(this.right, unit);
    }

    public Class getCategory() {
        return ValidateAreaInfo.class;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public float[] getPrintableArea(int units) {
        return new float[]{this.getTop(units), this.getLeft(units), this.getBottom(units), this.getRight(units)};
    }

    public String toString(int units, String unitsName) {
        if (unitsName == null) {
            unitsName = "";
        }
        float[] vals = this.getPrintableArea(units);
        String str = "(" + vals[0] + "," + vals[1] + ")->(" + vals[2] + "," + vals[3] + ")";
        return str + unitsName;
    }

    public boolean equals(Object object) {
        boolean ret = false;
        if (object instanceof ValidateAreaInfo) {
            ValidateAreaInfo mm = (ValidateAreaInfo)object;
            if (this.top == mm.top && this.left == mm.left && this.bottom == mm.bottom && this.right == mm.right) {
                ret = true;
            }
        }
        return ret;
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public int hashCode() {
        return (int)(this.top + 37.0f * this.right + 43.0f * this.bottom + 47.0f * this.right);
    }

    private static float convertFromMicrometers(float v, int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return v / (float)units;
    }

    private static void setAttribute(Element e, String name, String value) {
        AbstractXmlTranslate.setAttribute(e, name, value);
    }

    private static String getAttributeValue(Element e, String name) {
        return AbstractXmlTranslate.getAttributeValue(e, name);
    }
}

