/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.config.attribute;

import javax.print.attribute.PrintRequestAttribute;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;

public class ZoomScaleInfo
implements PrintRequestAttribute,
IXmlTranslate {
    private static final long serialVersionUID = -7921828338506740126L;
    public static final String NAME = "Zoomscaleinfo";
    private double scale = 1.0;
    private boolean autoFit = false;
    private int autoFitHeight = 1;
    private int autoFitWidth = 1;

    public ZoomScaleInfo() {
    }

    public ZoomScaleInfo(double pScale) {
        this.scale = ZoomScaleInfo.valideScale(pScale);
    }

    public ZoomScaleInfo(int width, int height) {
        this.autoFit = true;
        this.autoFitHeight = height;
        this.autoFitWidth = width;
    }

    public ZoomScaleInfo(int width, int height, double scale) {
        this.autoFit = true;
        this.autoFitHeight = height;
        this.autoFitWidth = width;
        this.scale = ZoomScaleInfo.valideScale(scale);
    }

    public Class getCategory() {
        return ZoomScaleInfo.class;
    }

    public void setScale(float pScale) {
        this.scale = ZoomScaleInfo.valideScale(pScale);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static double valideScale(double pScale) {
        if (pScale <= 0.0) {
            pScale = 1.0;
        }
        return pScale;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean equals(Object obj) {
        boolean b = false;
        if (obj instanceof ZoomScaleInfo) {
            ZoomScaleInfo info = (ZoomScaleInfo)obj;
            b = this.scale == info.scale && this.autoFit == info.autoFit && this.autoFitWidth == info.autoFitWidth && this.autoFitHeight == info.autoFitHeight;
        }
        return b;
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean autoFit) {
        this.autoFit = autoFit;
    }

    public int getAutoFitHeight() {
        return this.autoFitHeight;
    }

    public void setAutoFitHeight(int autoFitHeight) {
        this.autoFitHeight = autoFitHeight;
    }

    public int getAutoFitWidth() {
        return this.autoFitWidth;
    }

    public void setAutoFitWidth(int autoFitWidth) {
        this.autoFitWidth = autoFitWidth;
    }
}

