/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.config.ui;

import java.util.Map;
import java.util.StringTokenizer;
import kd.bos.print.core.ctrl.print.PropertyConfig;
import kd.bos.print.core.ctrl.print.config.IConfigModel;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;
import kd.bos.print.core.ctrl.print.config.PrintJobConfig;
import kd.bos.print.core.ctrl.print.config.ui.AbstractStartLocationModel;

public class PaperStartLocationModel
extends AbstractStartLocationModel {
    public PaperStartLocationModel() {
        this.load();
    }

    private void load() {
        String config = PropertyConfig.getPaper_Location();
        this.startContent.clear();
        if (config != null && !config.equals("")) {
            StringTokenizer st = new StringTokenizer(config, ":");
            while (st.hasMoreTokens()) {
                String oneConfig = st.nextToken();
                StringTokenizer stOne = new StringTokenizer(oneConfig, ",");
                String key = stOne.nextToken();
                key = key.replaceAll("!!", ":");
                float x = Float.parseFloat(stOne.nextToken());
                float y = Float.parseFloat(stOne.nextToken());
                this.startContent.put(key, new float[]{x, y});
            }
        }
    }

    @Override
    public void save() {
        PropertyConfig.setPaper_Location(this.toSaveString());
    }

    private String toSaveString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.startContent.entrySet()) {
            String printer = (String)entry.getKey();
            float[] values = (float[])entry.getValue();
            float x = values[0];
            float y = values[1];
            if (x == 0.0f && y == 0.0f) continue;
            printer = printer.replaceAll(":", "!!");
            sb.append(printer).append(",").append(x).append(",").append(y);
            sb.append(":");
        }
        return sb.toString();
    }

    @Override
    public Object copy() {
        return null;
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return null;
    }

    @Override
    public void set(IConfigModel from) {
    }

    @Override
    public void setDefault() {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public void installManager(PrintJobConfig manager) {
    }
}

