/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.config.ui;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import kd.bos.print.core.ctrl.print.config.IConfigModel;
import kd.bos.print.core.ctrl.print.config.IXmlTranslate;
import kd.bos.print.core.ctrl.print.config.attribute.PageRangeInfo;
import kd.bos.print.core.ctrl.print.config.ui.AbstractConfigModel;
import kd.bos.print.core.ctrl.print.config.xml.PrintGeneralTranslate;

public class PrintConfigModel
extends AbstractConfigModel {
    private PrintRequestAttributeSet printRequestAttrSet;
    private PrintService printServ = null;
    PrintService[] services;
    private DocAttributeSet docAttrSet;
    public static final int FRUGAL_FULLPAGE = 3;
    public static final int ENCODE_DEFAULT = 0;
    public static final int ENCODE_GBK = 1;
    public static final int ENCODE_BIG5 = 2;
    private boolean isDynamicPaperField = false;
    private int encode = 0;
    private int scaleType = 1;
    private int maxCopies = Integer.MAX_VALUE;
    private boolean printDirect = false;

    public void setPrintService(PrintService newValue) {
        this.printServ = newValue;
    }

    public void setCurrentServiceByName(String name) {
        PrintService[] ps = this.getPrintServices();
        if (name != null && !name.equals("") && ps != null && ps.length > 0) {
            int posi = name.lastIndexOf("\\");
            String suffix = name;
            if (posi > -1) {
                suffix = name.substring(posi);
            }
            for (int i = 0; i < ps.length; ++i) {
                String thename = ps[i].getName();
                if (!thename.equals(name) && !thename.endsWith(suffix)) continue;
                this.setPrintService(ps[i]);
                return;
            }
        }
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        if (this.printRequestAttrSet == null) {
            this.printRequestAttrSet = new HashPrintRequestAttributeSet();
        }
        return this.printRequestAttrSet;
    }

    public boolean addAttribute(Attribute attribute) {
        return this.getPrintRequestAttributeSet().add(attribute);
    }

    public PrintService getPrintService() {
        if (this.printServ == null) {
            this.printServ = this.lookupDefaultPrintService();
        }
        return this.printServ;
    }

    public PrintService getPrintServiceDirect() {
        return this.printServ;
    }

    public PrintService[] getPrintServices() {
        if (this.services == null || this.services.length == 0) {
            this.services = PrintServiceLookup.lookupPrintServices(null, null);
        }
        return this.services;
    }

    public int getPrintServiceIndex() {
        PrintService service = this.getPrintService();
        PrintService[] myservices = this.getPrintServices();
        int index = 0;
        for (int i = 0; i < myservices.length; ++i) {
            if (myservices[i] != service) continue;
            index = i;
            break;
        }
        return index;
    }

    private PrintService lookupDefaultPrintService() {
        PrintService[] myservices = this.getPrintServices();
        if (myservices.length > 0) {
            this.printServ = PrintServiceLookup.lookupDefaultPrintService();
            return this.printServ;
        }
        return null;
    }

    public DocAttributeSet getDocAttributeSet() {
        if (this.docAttrSet == null) {
            this.docAttrSet = new HashDocAttributeSet();
        }
        return this.docAttrSet;
    }

    public void clear() {
        this.reset();
        this.printServ = null;
        this.services = new PrintService[0];
    }

    public void reset() {
        if (this.printRequestAttrSet != null) {
            this.printRequestAttrSet.clear();
        }
        if (this.docAttrSet != null) {
            this.docAttrSet.clear();
        }
        this.encode = 0;
        this.scaleType = 1;
    }

    public boolean hasOddEvenPageRange() {
        if (this.printRequestAttrSet == null) {
            return false;
        }
        PageRangeInfo pageRangeInfo = (PageRangeInfo)this.printRequestAttrSet.get(PageRangeInfo.class);
        if (pageRangeInfo == null) {
            return false;
        }
        short type = pageRangeInfo.getPageRangeType();
        return type == 2;
    }

    @Override
    public void setDefault() {
        this.clear();
    }

    public boolean isDynamicPaper() {
        return this.isDynamicPaperField;
    }

    public void setDynamicPaper(boolean isDynamicpaper) {
        this.isDynamicPaperField = isDynamicpaper;
    }

    public int getEncode() {
        return this.encode;
    }

    public void setEncode(int encode) {
        this.encode = encode;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(int type) {
        this.scaleType = type;
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return new PrintGeneralTranslate(this);
    }

    @Override
    public void set(IConfigModel from) {
    }

    @Override
    public Object copy() {
        throw new UnsupportedOperationException();
    }

    public int getMaxCopies() {
        return this.maxCopies;
    }

    public void setMaxCopies(int max) {
        this.maxCopies = max;
    }

    public int getCopies() {
        Copies copies = (Copies)this.getPrintRequestAttributeSet().get(Copies.class);
        if (copies != null) {
            return copies.getValue();
        }
        return 1;
    }

    public void setCopies(int copys) {
        this.getPrintRequestAttributeSet().add(new Copies(copys));
    }

    public void setPrintDirect(boolean printDirect) {
        this.printDirect = printDirect;
    }

    public boolean getPrintDirect() {
        return this.printDirect;
    }
}

