/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.control;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.kdf.util.render.CellTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.TextRender;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.config.ui.AbstractStartLocationModel;
import kd.bos.print.core.ctrl.print.control.ControlPrint;
import kd.bos.print.core.ctrl.print.control.CtrlPageFormat;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.MultiPaper;
import kd.bos.print.core.model.ui.component.PainterInfo;

public class CtrlPrintable
implements Printable {
    protected KDPrinter printer;
    protected ControlPrint controlPrint;
    private int firstIndex = -1;
    private Canvas nowPaper = null;
    private static final Log log = LogFactory.getLog(CtrlPrintable.class);
    TextRender render = new TextRender();
    CellTextRender cellTextRender = new CellTextRender();

    public CtrlPrintable(ControlPrint control, KDPrinter aprinter) {
        this.controlPrint = control;
        this.printer = aprinter;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        pageIndex = KDPrinterUtils.setReversePageIndex(this.controlPrint.getAttribute(), pageIndex);
        int res = 1;
        Graphics2D g2d = (Graphics2D)g;
        if (this.firstIndex != pageIndex) {
            this.nowPaper = this.getPaper(pageIndex);
            this.firstIndex = pageIndex;
        }
        try {
            if (this.nowPaper != null) {
                res = 0;
                double screenrate = KDPrinterUtils.getScreenMapRate(KDPrinterUtils.SCREEN_RESOLUTION);
                g2d.scale(1.0 / screenrate, 1.0 / screenrate);
                CtrlPageFormat format = (CtrlPageFormat)pageFormat;
                AbstractStartLocationModel startLocationModel = this.printer.getPrintConfig().getStartLocationModel();
                String printerName = this.printer.getPrintConfig().getPrintService().getName();
                float[] pageStartLoaction = startLocationModel.getStartValues(printerName);
                float pageAdjustX = pageStartLoaction[0];
                float pageAdjustY = pageStartLoaction[1];
                boolean adjust = false;
                if (pageAdjustX != 0.0f || pageAdjustY != 0.0f) {
                    adjust = true;
                    pageAdjustX = pageAdjustX / 25.43f * 72.0f;
                    pageAdjustY = pageAdjustY / 25.43f * 72.0f;
                }
                if (adjust) {
                    g2d.translate(pageAdjustX, pageAdjustY);
                }
                format.getPainterInfo().setPreviewing(false);
                KDPrinterUtils.printOutCanvas(this.nowPaper, "PrintPaper");
                this.nowPaper.painting((Graphics)g2d, ((CtrlPageFormat)pageFormat).getPainterInfo());
                if (adjust) {
                    g2d.translate(-pageAdjustX, -pageAdjustY);
                }
                ((Graphics2D)g).scale(screenrate, screenrate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.controlPrint.isCancel()) {
            res = 1;
        }
        this.printer.getControlPrint().updatePrintingPrompt(res, pageIndex);
        return res;
    }

    protected void paintWatermark(Graphics p, PainterInfo info) {
    }

    public Canvas getPaper(int pageIndex) {
        int scaleType = this.printer.getPrintConfig().getModel().getScaleType();
        if (scaleType == 1) {
            return this.controlPrint.getPaper(pageIndex);
        }
        MultiPaper mPaper = new MultiPaper(scaleType, pageIndex, this.controlPrint);
        if (!mPaper.isEmpty()) {
            return mPaper;
        }
        return null;
    }

    public ControlPrint getControlPrint() {
        return this.controlPrint;
    }
}

