/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.control.ControlPrint;
import kd.bos.print.core.ctrl.print.util.TempFileUtil;
import kd.bos.print.core.execute.R1PrintPageProvider;
import kd.bos.print.core.model.ui.component.Paper;

public abstract class AbstractExport {
    private static final Log log = LogFactory.getLog(AbstractExport.class);

    public void begin(String fileNamePre, KDPrinter printer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String fileNamePre, KDPrinter printer) {
        try {
            Paper paper;
            this.begin(fileNamePre, printer);
            ControlPrint cPrint = printer.getControlPrint();
            int index = 0;
            while ((paper = cPrint.getPaper(index)) != null) {
                this.exportPaper(paper, fileNamePre, index);
                log.debug("PDF\u8f93\u51fa--\u5df2\u8f93\u51fa\u7b2c " + ++index + " \u9875");
            }
            this.end();
        }
        finally {
            this.clearTempFile(printer);
        }
    }

    public void end() {
    }

    protected abstract void exportPaper(Paper var1, String var2, int var3);

    protected void clearTempFile(KDPrinter printer) {
        try {
            int jobCount = printer.getPrintJob().getTaskCount();
            for (int i = 0; i < jobCount; ++i) {
                ((R1PrintPageProvider)printer.getPrintJob().getPrintJob(i).getPageProvider()).clearTempFile();
                boolean result = TempFileUtil.clearPrintTempFileDir();
                log.debug("\u6e05\u7406\u6253\u5370\u521b\u5efa\u7684\u4e34\u65f6\u6587\u4ef6\uff0c\u6e05\u9664\u7ed3\u679c\u4e3a\uff1a" + result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

