/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.swing.util.PrintFontUtil;
import kd.bos.print.core.service.PrtFont;

public class CustomFontMapper
implements FontMapper {
    public static final String CP_1252 = "Cp1252";
    private static final Log log = LogFactory.getLog(CustomFontMapper.class);
    private Map<String, Object> aliases = new HashMap<String, Object>();
    private Map<String, Object> mapper = new HashMap<String, Object>();
    private BaseFont defaultFont;

    public Map<String, Object> getMapper() {
        return this.mapper;
    }

    public Map<String, Object> getAliases() {
        return this.aliases;
    }

    public CustomFontMapper() {
        PrtFont defPrtFont = ExecuteService.getDefaultFont();
        this.insertFontInJAR(defPrtFont.getFontFileName());
        String tempFontDir = PrintFontUtil.getFontFilesDir();
        this.insertDirectory(tempFontDir);
        try {
            BaseFontParameters p = this.getBaseFontParameters(defPrtFont.getFontName());
            if (p == null) {
                this.defaultFont = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
                log.debug(String.format("Print-\u6ca1\u6709\u627e\u5230%s\u5b57\u4f53\uff0c\u4f7f\u7528\u4e86\u9ed8\u8ba4\u5b57\u4f53", defPrtFont.getFontName()));
            } else {
                log.debug("Print-\u9ed8\u8ba4\u5b57\u4f53\u4e3a\uff1a" + p.fontName);
                this.defaultFont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, null, null);
            }
        }
        catch (Exception e1) {
            log.debug(e1.getMessage());
            throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u5b57\u4f53mapper \u521d\u59cb\u5316\u9519\u8bef\u3002", (String)"CustomFontMapper_0", (String)"bos-print-core", (Object[])new Object[0])});
        }
    }

    public BaseFont awtToPdf(Font font) {
        try {
            int style;
            boolean styled = false;
            BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
            if (p == null && (style = font.getStyle()) != 0) {
                String styledName = font.getFontName();
                if ((style & 1) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Bold");
                }
                if ((style & 2) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Italic");
                }
                p = this.getBaseFontParameters(styledName);
                styled = true;
            }
            log.debug("Print-\u5b57\u4f53awtToPdf\uff1a" + font.getName());
            if (p == null) {
                if (this.defaultFont != null) {
                    log.debug("Print-\u5b57\u4f53awtToPdf\uff1ap\u4e3a\u7a7a\uff0c\u53d6\u9ed8\u8ba4\u5b57\u4f53");
                    return this.defaultFont;
                }
                log.debug("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b57\u4f53\uff1a" + font.getName() + " \u4e5f\u6ca1\u6709\u9ed8\u8ba4\u7684\u5b57\u4f53");
                throw new ExceptionConverter(new Exception(String.valueOf(String.valueOf(new StringBuilder("Can't find any font named [").append(font.getFontName()).append(" ] installed in your system, default font is not Available too.")))));
            }
            BaseFont basefont1 = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, null, null);
            return basefont1;
        }
        catch (Exception e) {
            if (this.defaultFont != null) {
                return this.defaultFont;
            }
            throw new ExceptionConverter(e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String finalName;
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        if ((finalName = name3x) == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }

    public BaseFontParameters getBaseFontParameters(String name) {
        String alias = (String)this.aliases.get(name);
        if (alias == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        BaseFontParameters p = (BaseFontParameters)this.mapper.get(alias);
        if (p == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        return p;
    }

    protected void insertNames(String[][] names, String path) {
        String main = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (!name[2].equals("1033")) continue;
            main = name[3];
            break;
        }
        if (main == null) {
            main = names[0][3];
        }
        BaseFontParameters p = new BaseFontParameters(path);
        this.mapper.put(main, p);
        for (int k = 0; k < names.length; ++k) {
            this.aliases.put(names[k][3], main);
        }
    }

    private Set<String> getCurTenantFonts() {
        HashSet<String> fontSet = new HashSet<String>(16);
        String tenantId = ExecuteService.getTenantId();
        QFilter qFilter = new QFilter("tenantid", "=", (Object)tenantId);
        qFilter.or(new QFilter("source", "=", (Object)"1"));
        QFilter[] filters = new QFilter[]{qFilter, new QFilter("billstatus", "=", (Object)"B")};
        Map fonts = BusinessDataReader.loadFromCache((String)"bos_prt_font", (QFilter[])filters);
        Map<String, DynamicObject> rcIdMap = fonts.values().stream().collect(Collectors.toMap(item -> item.getString("rcid"), item -> item));
        ArrayList<Long> rcIds = new ArrayList<Long>(10);
        for (DynamicObject item2 : fonts.values()) {
            rcIds.add(Long.parseLong(item2.getString("rcid")));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rcIds)};
        Map rcList = BusinessDataReader.loadFromCache((String)"bos_print_resource", (QFilter[])qFilters);
        for (DynamicObject rcObj : rcList.values()) {
            long rcId = rcObj.getLong("id");
            String fontFileName = rcObj.getString("filename");
            String suffix = fontFileName.substring(fontFileName.lastIndexOf("."));
            fontFileName = rcIdMap.get(String.valueOf(rcId)).getString("number") + suffix;
            fontSet.add(fontFileName.toLowerCase(Locale.getDefault()));
        }
        return fontSet;
    }

    public int insertDirectory(String dir) {
        File file = new File(dir);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] files = file.listFiles();
        int count = 0;
        if (files == null) {
            return 0;
        }
        Set<String> fontSet = this.getCurTenantFonts();
        for (int k = 0; k < files.length; ++k) {
            file = files[k];
            if (!fontSet.contains(file.getName().toLowerCase(Locale.getDefault()))) continue;
            String name = file.getPath().toLowerCase(Locale.getDefault());
            try {
                if (!name.contains(".") || name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".afm")) {
                    String[][] names = BaseFont.getFullFontName((String)file.getPath(), (String)CP_1252, null);
                    this.insertNames(names, file.getPath());
                    ++count;
                    continue;
                }
                if (!name.endsWith(".ttc")) continue;
                String[] ttcs = BaseFont.enumerateTTCNames((String)file.getPath());
                for (int j = 0; j < ttcs.length; ++j) {
                    String nt = String.valueOf(String.valueOf(new StringBuilder(String.valueOf(file.getPath())).append(",").append(j)));
                    String[][] names = BaseFont.getFullFontName((String)nt, (String)CP_1252, null);
                    this.insertNames(names, nt);
                }
                ++count;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    public boolean insertFontInJAR(String name) {
        try {
            URL fontURL = CustomFontMapper.class.getClassLoader().getResource(name);
            if (!name.contains(".") || name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".afm")) {
                String[][] names = BaseFont.getFullFontName((String)fontURL.toString(), (String)CP_1252, null);
                this.insertNames(names, fontURL.toString());
            } else if (name.endsWith(".ttc")) {
                String[] ttcs = BaseFont.enumerateTTCNames((String)fontURL.toString());
                for (int j = 0; j < ttcs.length; ++j) {
                    String nt = String.valueOf(String.valueOf(new StringBuilder(String.valueOf(String.valueOf(fontURL.toString()))).append(",").append(j)));
                    String[][] names = BaseFont.getFullFontName((String)nt, (String)CP_1252, null);
                    this.insertNames(names, nt);
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static class BaseFontParameters {
        private String fontName;
        private String encoding;
        private boolean embedded;
        private boolean cached;

        public String getFontName() {
            return this.fontName;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public BaseFontParameters(String fontName) {
            this.fontName = fontName;
            this.encoding = "Identity-H";
            this.embedded = true;
            this.cached = true;
        }
    }
}

