/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import java.io.OutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.io.PdfExport;
import kd.bos.print.core.ctrl.print.io.XlsExport;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeExportEvent;

public class IOManager {
    private static final Log log = LogFactory.getLog(IOManager.class);
    private KDPrinter printer;

    public IOManager(KDPrinter printer) {
        this.printer = printer;
    }

    public void exportToPdf(String fileName) {
        this.printer.preParePrint();
        PdfExport export = new PdfExport();
        export.export(this.getFileName(fileName), this.printer);
    }

    public void exportToXls(String fileName) {
        this.printer.preParePrint();
        XlsExport export = new XlsExport();
        export.export(this.getFileName(fileName), this.printer);
    }

    private String getFileName(String fileName) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeExportEvent evt = new BeforeExportEvent();
            evt.setFileTplName(fileName);
            pluginProxy.fireBeforeExport(evt);
            fileName = evt.getFileTplName();
        }
        return fileName;
    }

    @Deprecated
    public void exportToPdf(OutputStream os) {
        this.exportToPdf("");
    }

    @Deprecated
    public void exportToPdf(String fileName, OutputStream os) {
        this.exportToPdf(fileName);
    }

    @Deprecated
    public void exportToXls(String fileName, OutputStream os) {
        this.exportToXls(fileName);
    }
}

