/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.print.io.BadDataFormatException;
import kd.bos.print.core.ctrl.print.io.IndexsElement;

public class IndexAccessFile {
    RandomAccessFile randomFile;
    IndexsElement indexTree;
    public static final String STANDARD_LINE_SEPARATOR = "\r\n";
    public static final int POSITIONLENGTH = 32;
    private long indexOfIndexStart;
    private long indexOfIndexLength;
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private static final Log log = LogFactory.getLog(IndexAccessFile.class);

    public IndexAccessFile(String path) throws IOException, BadDataFormatException {
        this.randomFile = new RandomAccessFile(path, "rw");
    }

    private IndexsElement getIndexs() {
        if (this.indexTree == null) {
            try {
                this.indexTree = new IndexsElement(this);
            }
            catch (IOException e) {
                throw new AssertionError((Object)("Failed loading file:" + e.getMessage() + "."));
            }
            catch (BadDataFormatException e) {
                throw new AssertionError((Object)("Failed loading file:" + e.getMessage() + "."));
            }
        }
        return this.indexTree;
    }

    public void initWrite(String str) throws IOException {
        this.randomFile.setLength(0L);
        this.getIndexs().clear();
        this.write(str);
        this.initIndexOfIndex();
    }

    private void initIndexOfIndex() throws IOException {
        String placeholder = this.toLongIntStr(0L);
        String indexPre = "<indexOfIndex start=\"";
        long position = this.randomFile.getFilePointer();
        this.indexOfIndexStart = position + (long)indexPre.length();
        this.indexOfIndexLength = this.indexOfIndexStart + 32L + 1L + 1L + 8L;
        this.write(indexPre + placeholder + "\" " + "length" + "=\"" + placeholder + "\" />");
        this.writeNewLine();
    }

    public void write(String str) throws IOException {
        this.write(null, str);
    }

    public void writeNewLine() throws IOException {
        this.write(STANDARD_LINE_SEPARATOR);
    }

    public long write(String index_key, String str) throws IOException {
        if (str == null || "".equals(str)) {
            return 0L;
        }
        byte[] bytes = this.StringToBytes(str);
        long pos = this.randomFile.getFilePointer();
        this.randomFile.write(bytes);
        int length = bytes.length;
        if (index_key != null) {
            this.getIndexs().add(index_key, (int)pos, length);
        }
        return length;
    }

    protected byte[] readBytes(int position, int size) throws IOException {
        this.randomFile.seek(position);
        byte[] bytes = new byte[size];
        this.randomFile.read(bytes);
        return bytes;
    }

    public void close() throws IOException {
        this.randomFile.close();
    }

    public void closeWrite(String closeElement) throws IOException {
        this.writeIndexs();
        if (closeElement != null) {
            this.write(closeElement);
        }
        this.randomFile.close();
    }

    private void writeIndexs() throws IOException {
        if (!this.getIndexs().isEmpty()) {
            String indexs = this.indexTree.toString();
            long start = this.randomFile.getFilePointer();
            long length = this.write(null, indexs);
            long position = this.randomFile.getFilePointer();
            this.updateIndexOfIndex(start, length);
            this.randomFile.seek(position);
        }
    }

    public String getIndexContent() {
        return this.getIndexs().toString();
    }

    private void updateIndexOfIndex(long indexPosition, long length) throws IOException {
        this.randomFile.seek(this.indexOfIndexStart);
        this.write(this.toLongIntStr(indexPosition));
        this.randomFile.seek(this.indexOfIndexLength);
        this.write(this.toLongIntStr(length));
    }

    public byte[] StringToBytes(String str) {
        try {
            this.baos.reset();
            Writer writer = this.makeWriter(this.baos, "UTF8");
            writer.write(str);
            writer.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.baos.toByteArray();
    }

    protected Writer makeWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), enc));
        return writer;
    }

    private String toLongIntStr(long value) {
        String text = String.valueOf(value);
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        int addLength = 32 - length;
        for (int i = 0; i < addLength; ++i) {
            sb.append("0");
        }
        sb.append(text);
        return sb.toString();
    }

    public long length() throws IOException {
        return this.randomFile.length();
    }

    public String readLine() throws IOException {
        return this.randomFile.readLine();
    }
}

