/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.ctrl.print.io.BadDataFormatException;
import kd.bos.print.core.ctrl.print.io.IndexAccessFile;

public class IndexsElement {
    private Map<String, Object> indexMap = new HashMap<String, Object>();
    public static final String INDEX_INDEX = "indexOfIndex";
    public static final String NAME = "indexs";
    public static final String INDEX_NAME = "index";
    public static final String ATTRI_KEY = "key";
    public static final String ATTRI_START = "start";
    public static final String ATTRI_LENGTH = "length";

    public IndexsElement(IndexAccessFile fileWriter) throws IOException, BadDataFormatException {
        this.loadIndexs(fileWriter);
    }

    public void clear() {
        this.indexMap.clear();
    }

    private void loadIndexs(IndexAccessFile fileWriter) throws IOException, BadDataFormatException {
        if (fileWriter.length() <= 0L) {
            return;
        }
        String indexOfIndex = fileWriter.readLine();
        boolean isFind = false;
        for (int maxRow = 0; indexOfIndex != null && maxRow < 10; ++maxRow) {
            if (indexOfIndex.indexOf(INDEX_INDEX) >= 0) {
                isFind = true;
                break;
            }
            indexOfIndex = fileWriter.readLine();
        }
        if (isFind) {
            try {
                int startIndex = indexOfIndex.indexOf(ATTRI_START);
                startIndex = startIndex + ATTRI_START.length() + 2;
                String startPositon = indexOfIndex.substring(startIndex, startIndex + 32);
                int lendthIndex = indexOfIndex.indexOf(ATTRI_LENGTH);
                lendthIndex = lendthIndex + ATTRI_LENGTH.length() + 2;
                String lengthStr = indexOfIndex.substring(lendthIndex, lendthIndex + 32);
                int sp = Integer.parseInt(startPositon);
                int n = Integer.parseInt(lengthStr);
            }
            catch (Exception e) {
                throw new BadDataFormatException(e.getMessage(), e);
            }
        } else {
            throw new BadDataFormatException("Bad file format,not find indexOfindex.");
        }
    }

    public int[] get(String key) {
        Pair pair = (Pair)this.indexMap.get(key);
        if (pair != null) {
            int[] pairs = new int[]{pair.getPos(), pair.getLength()};
            return pairs;
        }
        return new int[0];
    }

    public void add(String key, int pos, int length) {
        this.indexMap.put(key, new Pair(pos, length));
    }

    public void add(String id, int pos) {
        this.add(id, pos, -1);
    }

    public boolean isEmpty() {
        return this.indexMap.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" <indexs>");
        sb.append(this.newLine());
        for (Map.Entry<String, Object> entry : this.indexMap.entrySet()) {
            String key = entry.getKey();
            Pair pair = (Pair)entry.getValue();
            sb.append("  <index");
            sb.append("  key=\"" + key + "\"");
            if (pair.getPos() >= 0) {
                sb.append(" start=\"" + pair.getPos() + "\"");
            }
            if (pair.getLength() >= 0) {
                sb.append(" length=\"" + pair.getLength() + "\"");
            }
            sb.append("/>");
            sb.append(this.newLine());
        }
        sb.append(" </indexs>");
        sb.append(this.newLine());
        return sb.toString();
    }

    private String newLine() {
        return "\r\n";
    }

    protected static class Pair {
        private int pos = -1;
        private int length = -1;

        public int getPos() {
            return this.pos;
        }

        public int getLength() {
            return this.length;
        }

        public Pair(int pos, int length) {
            this.pos = pos;
            this.length = length;
        }
    }
}

