/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import java.io.IOException;
import kd.bos.print.core.ctrl.print.ConfigManager;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.io.BadDataFormatException;
import kd.bos.print.core.ctrl.print.io.IndexAccessFile;
import kd.bos.print.core.ctrl.print.io.KDPException;
import kd.bos.print.core.ctrl.print.printjob.IPrintJob;
import kd.bos.print.core.model.ui.component.Page;

public class KDPFile {
    public static final String VERSION = "1.0";
    public static final String T_KDP = "kdp";
    public static final String A_PAGECOUNT = "pageCount";
    IndexAccessFile indexFileWriter;

    public KDPFile(String path) throws KDPException {
        try {
            this.indexFileWriter = new IndexAccessFile(path);
        }
        catch (BadDataFormatException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                throw new KDPException(e);
            }
            throw new KDPException(e);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                throw new KDPException(e);
            }
            throw new KDPException(e);
        }
    }

    public void createFile() {
    }

    public void addJobBegin(IPrintJob childJob) throws IOException {
        String jobname = "printjob";
        String key = jobname + childJob.getID();
        this.write(key, "  <" + jobname + " id=\"" + childJob.getID() + "\" " + A_PAGECOUNT + "=\"" + childJob.getPageCount() + "\">");
    }

    public void addJobEnd(IPrintJob childJob) throws IOException {
        this.write("  </printjob>");
    }

    public void addPage(Page page, int index, String jobname) throws IOException {
    }

    private void write(String key, String content) throws IOException {
        this.indexFileWriter.write(key, content);
        this.indexFileWriter.write(null, "\r\n");
    }

    private void write(String content) throws IOException {
        this.write(null, content);
    }

    public void saveStyles() throws IOException {
    }

    public void addConfig(ConfigManager printConfig) throws IOException {
    }

    public void closeSave() throws IOException {
        this.indexFileWriter.closeWrite("</kdp>");
    }

    public void save(KDPrinter printer) throws IOException {
        this.indexFileWriter.initWrite("<?xml version=\"1.0\"?>\r\n<kdp version=\"1.0\">\r\n");
        IPrintJob printJob = printer.getPrintJob();
        int taskCount = printJob.getTaskCount();
        for (int i = 0; i < taskCount; ++i) {
            Page page;
            IPrintJob childJob = printJob.getPrintJob(i);
            this.addJobBegin(childJob);
            int index = 0;
            while ((page = childJob.getPage(index)) != null) {
                this.addPage(page, index, childJob.getID());
                ++index;
            }
            this.addJobEnd(childJob);
        }
        this.saveStyles();
        this.addConfig(printer.getPrintConfig());
        this.closeSave();
    }

    public Page getPage(int index, String jobid) {
        return null;
    }

    public void close() throws IOException {
        this.indexFileWriter.close();
    }
}

