/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.config.PrintJobConfig;
import kd.bos.print.core.ctrl.print.control.ControlPrint;
import kd.bos.print.core.ctrl.print.io.AbstractExport;
import kd.bos.print.core.ctrl.print.io.PrintFontMapper;
import kd.bos.print.core.ctrl.print.io.WatermarkPageEvent;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.component.Paper;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.bos.print.core.plugin.event.ExpFileEvent;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.core.utils.PrintConst;

public class PdfExport
extends AbstractExport {
    private ByteArrayOutputStream os;
    private Document document;
    private PdfContentByte pdfContentByte;
    private int pdfIndex = 1;
    private int curPdfPageSize = 1;
    private PrtAttach attach;
    public FontMapper DEFAULT_FONTMAPPER = PrintFontMapper.createInstance();
    private static final Log log = LogFactory.getLog(PdfExport.class);
    private KDPrinter printer;

    public PdfExport() {
        this.attach = new PrtAttach();
        this.attach.setTaskId(ExecuteContext.get().getTaskId());
        this.attach.setOrgId(ExecuteService.getUserService().getOrgId());
        this.attach.setAppId(ExecuteContext.get().getAppId());
        this.attach.setUserId(ExecuteService.getUserId());
        this.attach.setFormId(ExecuteContext.get().getFormId());
    }

    @Deprecated
    public PdfExport(OutputStream os) {
        this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(String fileName, KDPrinter printer) {
        try {
            Paper paper;
            this.begin(fileName, printer);
            ControlPrint cPrint = printer.getControlPrint();
            int index = 0;
            while ((paper = cPrint.getPaper(index)) != null) {
                if (this.curPdfPageSize > PrintConst.onePdfMaxPage()) {
                    this.endOne();
                    this.curPdfPageSize = 1;
                    this.begin(fileName, printer);
                }
                this.exportPaper(paper, fileName, index);
                ++this.curPdfPageSize;
                log.debug("PDF\u8f93\u51fa--\u5df2\u8f93\u51fa\u7b2c " + ++index + " \u9875");
            }
            this.end(index);
        }
        finally {
            this.clearTempFile(printer);
        }
    }

    @Override
    public void begin(String tplName, KDPrinter printer) {
        this.os = new ByteArrayOutputStream();
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        String fileName = this.pdfIndex == 1 ? tplName + ".pdf" : tplName + "-" + (this.pdfIndex - 1) + ".pdf";
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            ExpFileEvent evt = new ExpFileEvent(fileName, this.pdfIndex);
            pluginProxy.fireBeforeExpFile(evt);
            fileName = evt.getFileName();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".pdf")) {
                fileName = fileName + ".pdf";
            }
        }
        attachDetail.setFileName(fileName);
        attachDetail.setSource("B");
        this.attach.addAttachDetail(attachDetail);
        this.printer = printer;
        ControlPrint cPrint = printer.getControlPrint();
        Paper paper = cPrint.getPaper(0);
        float width = paper.getWidth();
        float height = paper.getHeight();
        Rectangle rc = new Rectangle((float)StyleUtil.pixelToPt((long)((long)width)), (float)StyleUtil.pixelToPt((long)((long)height)));
        PrintJobConfig attributeManager = (PrintJobConfig)paper.getPainterInfo().getAttributeManager();
        float topM = attributeManager.getBodyTopMargin(1000);
        float bottomM = attributeManager.getBodyBottomMargin(1000);
        float leftM = attributeManager.getLeftMargin(1000);
        float rightM = attributeManager.getRightMargin(1000);
        float topPt = (float)StyleUtil.lomToPt((double)(topM * 10.0f));
        float bottomPt = (float)StyleUtil.lomToPt((double)(bottomM * 10.0f));
        float leftPt = (float)StyleUtil.lomToPt((double)(leftM * 10.0f));
        float rightPt = (float)StyleUtil.lomToPt((double)(rightM * 10.0f));
        try {
            this.document = new Document(rc, leftPt, rightPt, topPt, bottomPt);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
            if (printer.getWaterMark() != null) {
                WatermarkPageEvent watermarkEvent = new WatermarkPageEvent();
                watermarkEvent.setWaterMark(printer.getWaterMark());
                pdfWriter.setPageEvent((PdfPageEvent)watermarkEvent);
            }
            this.document.addTitle(fileName);
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
        }
        catch (DocumentException e) {
            throw new RuntimeException("PDF Document error:" + e.getMessage(), e);
        }
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        float widthPt = (float)StyleUtil.pixelToPt((long)((long)paper.getWidth()));
        float heightPt = (float)StyleUtil.pixelToPt((long)((long)paper.getHeight()));
        Rectangle rc = new Rectangle(widthPt, heightPt);
        this.document.setPageSize(rc);
        this.document.newPage();
        PdfTemplate pdftemplate = this.pdfContentByte.createTemplate(widthPt, heightPt);
        Graphics2D graphics2d = pdftemplate.createGraphics(widthPt, heightPt, this.DEFAULT_FONTMAPPER);
        graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
        PainterInfo painterInfo = paper.getPainterInfo();
        paper.painting((Graphics)graphics2d, painterInfo);
        graphics2d.dispose();
        pdftemplate.setWidth(widthPt);
        pdftemplate.setHeight(heightPt);
        this.pdfContentByte.addTemplate(pdftemplate, 0.0f, 0.0f);
    }

    private void endOne() {
        try {
            this.document.close();
            this.os.flush();
            PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)this.attach.getAttachDetail().get(this.pdfIndex - 1);
            String filePath = ExecuteService.getAttachService().savePrtFile(attachDetail.getFileName(), this.os.toByteArray());
            attachDetail.setFilePath(filePath);
            ++this.pdfIndex;
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void end(int pageTotal) {
        this.end();
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            EndExportEvent evt = new EndExportEvent();
            evt.setPrtAttach(this.attach);
            evt.setPageTotal(pageTotal);
            pluginProxy.fireEndOutput(evt);
        }
    }

    @Override
    public void end() {
        this.endOne();
        ExecuteService.getAttachService().savePrtResult(this.attach);
    }

    public void loadFont() {
        Font defaultfont = KDFont.loadFontFromJAR((String)ExecuteService.getDefaultFont().getFontName(), (int)0, (float)12.0f);
        this.DEFAULT_FONTMAPPER.awtToPdf(defaultfont);
    }
}

