/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.server.ExportException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.io.AbstractExport;
import kd.bos.print.core.ctrl.print.xls.R1PrintV2XExporter;
import kd.bos.print.core.ctrl.print.xls.output.OutputHelper;
import kd.bos.print.core.ctrl.print.xls.widget.XlsPaper;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.Paper;
import kd.bos.print.core.service.PrtAttach;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class XlsExport
extends AbstractExport {
    private int horIndetion;
    private int verIndetion;
    private ByteArrayOutputStream outputStream;
    private R1PrintV2XExporter exporter = null;
    private OutputHelper _helper;
    private Workbook workbook;
    private Logger log = Logger.getLogger(this.getClass());
    private static final String XLS_SUFFIX = ".xlsx";
    private PrtAttach attach;

    public XlsExport(int horIndetion, int verIndetion) {
        this.horIndetion = horIndetion;
        this.verIndetion = verIndetion;
        this.workbook = new SXSSFWorkbook(5000);
        ((SXSSFWorkbook)this.workbook).setZip64Mode(Zip64Mode.AsNeeded);
        this._helper = new OutputHelper(this.workbook);
        this.attach = new PrtAttach();
        this.attach.setTaskId(ExecuteContext.get().getTaskId());
        this.attach.setOrgId(ExecuteService.getUserService().getOrgId());
        this.attach.setAppId(ExecuteContext.get().getAppId());
        this.attach.setUserId(ExecuteService.getUserId());
        this.attach.setFormId(ExecuteContext.get().getFormId());
    }

    public XlsExport() {
        this(10, 5);
    }

    @Deprecated
    public XlsExport(OutputStream outputStream) {
        this(10, 5);
    }

    @Override
    public void begin(String fileNamePre, KDPrinter printer) {
        this.outputStream = new ByteArrayOutputStream();
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        attachDetail.setFileName(fileNamePre + XLS_SUFFIX);
        attachDetail.setSource("B");
        this.attach.addAttachDetail(attachDetail);
        try {
            this.exporter = new R1PrintV2XExporter();
        }
        catch (ExportException exportException) {
            // empty catch block
        }
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        XlsPaper node = (XlsPaper)this.exporter.translate((IPainter)paper, null);
        this._helper.handPaper(node, this.horIndetion, this.verIndetion);
    }

    @Override
    public void end() {
        try {
            this._helper.endOutput(this.horIndetion, this.verIndetion);
            this.workbook.write((OutputStream)this.outputStream);
            this.outputStream.flush();
            this.outputStream.close();
            PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)this.attach.getAttachDetail().get(0);
            String filePath = ExecuteService.getAttachService().savePrtFile(attachDetail.getFileName(), this.outputStream.toByteArray());
            attachDetail.setFilePath(filePath);
            ExecuteService.getAttachService().savePrtResult(this.attach);
            this.workbook = null;
            this._helper.clearStyleMap();
            this.log.debug((Object)(ResManager.loadKDString((String)"\u5bfc\u51fa\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"XlsExport_2", (String)"bos-print-core", (Object[])new Object[0]) + System.currentTimeMillis() + "ms"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private R1PrintV2XExporter getExporter() {
        if (this.exporter != null) {
            return this.exporter;
        }
        try {
            this.exporter = new R1PrintV2XExporter();
        }
        catch (ExportException e) {
            return null;
        }
        return this.exporter;
    }
}

