/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.printjob;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.print.DocFlavor;
import javax.print.attribute.PrintRequestAttributeSet;
import kd.bos.print.core.ctrl.kdf.headfootdesigner.HeadFootModel;
import kd.bos.print.core.ctrl.print.IVariantParser;
import kd.bos.print.core.ctrl.print.KDPConstant;
import kd.bos.print.core.ctrl.print.KDPrinter;
import kd.bos.print.core.ctrl.print.config.PrintJobConfig;
import kd.bos.print.core.ctrl.print.config.ui.HeaderFooterModel;
import kd.bos.print.core.ctrl.print.config.ui.IDialogActionListener;
import kd.bos.print.core.ctrl.print.config.ui.PageSetupModel;
import kd.bos.print.core.ctrl.print.control.CtrlPageFormat;
import kd.bos.print.core.ctrl.print.control.PaperInfo;
import kd.bos.print.core.ctrl.print.printjob.IBeforePaginationListener;
import kd.bos.print.core.ctrl.print.printjob.IPageProvider;
import kd.bos.print.core.ctrl.print.printjob.IPrintJob;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.Page;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.component.Paper;

public abstract class AbstractPrintJob
implements IPrintJob,
IDialogActionListener {
    protected KDPrinter printer;
    protected DocFlavor contentType = KDPConstant.DOCFLAVOR_TYPE;
    private String id;
    public static final int UNKNOW_PAGECOUNT = -1;
    protected IPageProvider pagerProvider;
    protected IPrintJob parent;
    protected int pageCount = -1;
    protected PaperInfo paperInfo;
    protected int currentPaperIndex = 0;
    private PainterInfo printPainterInfo;
    CtrlPageFormat pageFormat;
    Set beginGetPageListeners = new HashSet();
    protected Map changedPageBuffer;
    protected PrintJobConfig printAttrMana = null;
    private IVariantParser variantParser;
    protected Object userObj;

    public AbstractPrintJob() {
        this.setID("" + this.hashCode());
    }

    public AbstractPrintJob(String name) {
        this.setID(name);
    }

    @Override
    public void setPrinter(KDPrinter printer) {
        this.printer = printer;
    }

    @Override
    public KDPrinter getPrinter() {
        return this.printer;
    }

    @Override
    public PrintJobConfig getConfig() {
        if (this.printer != null && this.parent != null && this.parent.getConfig() != null) {
            return this.parent.getConfig();
        }
        if (this.printAttrMana == null) {
            this.printAttrMana = new PrintJobConfig(this, this.printer);
        }
        return this.printAttrMana;
    }

    public void setConfig(PrintJobConfig config) {
        this.printAttrMana = config;
    }

    @Override
    public void preview() {
    }

    @Override
    public void approve() {
        this.checkChange();
    }

    @Override
    public void checkChange() {
        if (this.getConfig().isChange()) {
            this.rePagination();
        }
    }

    @Override
    public void rePagination() {
        this.getConfig().setChange(false);
        this.preparePagination();
    }

    @Override
    public Paper createPaper(int index) {
        Paper paper = null;
        this.currentPaperIndex = index;
        Page page = this.getPage(index);
        if (page != null) {
            paper = this.createNewPaper(index);
            page.setX(this.getPaperInfo().getPageBounds().x);
            page.setY(this.getPaperInfo().getPageBounds().y);
            paper.setBody(page);
            this.setWaterMark(paper, index);
        }
        if (paper != null) {
            paper.setDynamicPaper(this.isDynamicPaper());
        }
        return paper;
    }

    private void setWaterMark(Paper paper, int index) {
        boolean isOnlyFirst;
        PageSetupModel pModel = this.getConfig().getPageSetupModel();
        if (pModel.getWaterMark() != null && pModel.getWaterMark().getText() != null && (!(isOnlyFirst = pModel.isWaterMark_onlyFirstPage()) || isOnlyFirst && index == 0)) {
            paper.setWaterMark(pModel.getWaterMark());
        }
    }

    protected Paper createNewPaper(int index) {
        Image backImage;
        PageSetupModel model = this.getConfig().getPageSetupModel();
        PaperInfo thepaperInfo = this.getPaperInfo();
        Paper paper = new Paper(index);
        Color backColor = model.getBackGroundColor();
        if (backColor != null) {
            paper.setBackGround(backColor);
        }
        if ((backImage = model.getBackGround()) != null) {
            paper.setBackGroundImage(backImage);
            paper.setBackGroundImageFillMode(model.getBackGroundFillMode());
        }
        Dimension paperDim = thepaperInfo.getPaperSize();
        paper.setPainterSize((float)paperDim.width, (float)paperDim.height);
        this.createHeaderFooter(paper);
        paper.setPainterInfo(this.getPrintPainterInfo());
        return paper;
    }

    protected void createHeaderFooter(Paper paper) {
        this.createHeader(paper);
        this.createFooter(paper);
    }

    protected void createHeader(Paper paper) {
        Canvas header = this.getHeader();
        paper.setHeader(header);
    }

    protected void createFooter(Paper paper) {
        Canvas footer = this.getFooter();
        paper.setFooter(footer);
    }

    @Override
    public Page getPage(int index) {
        if (this.changedPageBuffer != null) {
            return (Page)this.changedPageBuffer.get(index);
        }
        return null;
    }

    @Override
    public Object getContentType() {
        return this.contentType;
    }

    @Override
    public void clear() {
        this.pageCount = -1;
        this.changedPageBuffer = null;
    }

    @Override
    public void addModifiedPage(Page page) {
        if (this.changedPageBuffer == null) {
            this.changedPageBuffer = new HashMap();
        }
        this.changedPageBuffer.put(page.getIndex(), page);
    }

    @Override
    public void setPageProvider(IPageProvider virtualModel) {
        this.pagerProvider = virtualModel;
    }

    @Override
    public IPageProvider getPageProvider() {
        return this.pagerProvider;
    }

    @Override
    public PaperInfo getPaperInfo() {
        if (this.parent != null && this.parent.getPaperInfo() != null) {
            return this.parent.getPaperInfo();
        }
        if (this.paperInfo == null) {
            this.paperInfo = new PaperInfo();
        }
        return this.paperInfo;
    }

    @Override
    public void setPaperInfo(PaperInfo info) {
        this.paperInfo = info;
    }

    @Override
    public void setParent(IPrintJob jobs) {
        this.parent = jobs;
    }

    @Override
    public void setHeader(Canvas head) {
        this.getConfig().getHeaderFooterModel().setHeader(head);
    }

    @Override
    public void setFooter(Canvas foot) {
        this.getConfig().getHeaderFooterModel().setFooter(foot);
    }

    public void setHeader(HeadFootModel foot) {
        this.getConfig().getHeaderFooterModel().setHeaderModel(foot);
    }

    public void setFooter(HeadFootModel foot) {
        this.getConfig().getHeaderFooterModel().setFooterModel(foot);
    }

    @Override
    public Canvas getHeader() {
        Canvas header = null;
        header = this.getConfig().getHeader();
        if (header != null) {
            this.initHeaderBounds(header);
        }
        return header;
    }

    @Override
    public Canvas getFooter() {
        Canvas footer = null;
        footer = this.getConfig().getFooter();
        if (footer != null) {
            this.initFooterBounds(footer);
        }
        return footer;
    }

    protected void initHeaderBounds(Canvas header) {
        Rectangle2D.Float headRect = this.getPaperInfo().getPageHeadBounds();
        header.setPainterLocation(headRect.x, headRect.y);
        header.setPainterSize(headRect.width, (float)header.getPainterSize().getHeight());
    }

    protected void initFooterBounds(Canvas footer) {
        Rectangle2D.Float footdRect = this.getPaperInfo().getPageFootBounds();
        float fh = (float)footer.getPainterSize().getHeight();
        if (fh < 0.0f) {
            fh = 0.0f;
        }
        footer.setPainterLocation(footdRect.x, (float)((double)footdRect.y + (double)(footdRect.height - fh) * this.getPaperInfo().getScale()));
        footer.setPainterSize(footdRect.width, fh);
    }

    @Override
    public PainterInfo getPrintPainterInfo() {
        if (this.printPainterInfo == null) {
            this.printPainterInfo = new PainterInfo();
        }
        this.printPainterInfo.setAttributeManager((Object)this.getConfig());
        this.printPainterInfo.setVariantParser(this.getVariantParser());
        this.printPainterInfo.setEncode(this.printer.getPrintConfig().getEncode());
        return this.printPainterInfo;
    }

    @Override
    public void setPageCount(int nums) {
        this.pageCount = nums < 0 ? -1 : nums;
    }

    @Override
    public int getPageCount2() {
        return this.pageCount;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        return (PageFormat)this.pageFormat.clone();
    }

    @Override
    public int getTaskCount() {
        return 1;
    }

    @Override
    public void update() {
        HeaderFooterModel headerFooterModel = this.getConfig().getHeaderFooterModel();
        if (headerFooterModel != null) {
            headerFooterModel.setValid(false);
        }
        this.updatePageFormat();
        this.updatePaperInfo();
    }

    private void updatePageFormat() {
        if (this.getConfig() != null) {
            this.pageFormat = KDPrinterUtils.getCtrlPageFormat(this.getConfig().getPrintRequestAttributeSet(), this.getID());
            this.pageFormat.setPainterInfo(this.getPrintPainterInfo());
        }
    }

    protected void updatePaperInfo() {
        if (this.getConfig() == null) {
            return;
        }
        PrintJobConfig manager = this.getConfig();
        PrintRequestAttributeSet printRequestSet = manager.getPrintRequestAttributeSet();
        int count = this.getTaskCount();
        if (count > 1) {
            // empty if block
        }
        Rectangle pageRect = KDPrinterUtils.getPageBounds(printRequestSet, KDPrinterUtils.SCREEN_RESOLUTION);
        Rectangle pageHeadRect = KDPrinterUtils.getPageHeadBounds(printRequestSet, KDPrinterUtils.SCREEN_RESOLUTION);
        Rectangle pageFootRect = KDPrinterUtils.getPageFootBounds(printRequestSet, KDPrinterUtils.SCREEN_RESOLUTION);
        Dimension paperDim = KDPrinterUtils.getPaperSize(printRequestSet, KDPrinterUtils.SCREEN_RESOLUTION);
        int width = paperDim.width;
        int height = paperDim.height;
        PaperInfo thepaperInfo = this.getPaperInfo();
        thepaperInfo.setScale(this.getScale(printRequestSet));
        thepaperInfo.setPageBounds(pageRect.x, pageRect.y, pageRect.width, pageRect.height);
        thepaperInfo.setPageHeadBounds(pageHeadRect.x, pageHeadRect.y, pageHeadRect.width, pageHeadRect.height);
        thepaperInfo.setPageFootBounds(pageFootRect.x, pageFootRect.y, pageFootRect.width, pageFootRect.height);
        thepaperInfo.setPaperSize(width, height);
        thepaperInfo.setIsDynamicPaper(this.printer.isDynamicPaper());
    }

    protected double getScale(PrintRequestAttributeSet printRequestSet) {
        return KDPrinterUtils.getZoomScaleInfo(printRequestSet);
    }

    @Override
    public PrintJobConfig[] getJobsConfigs() {
        PrintJobConfig[] managers = new PrintJobConfig[1];
        if (this.getConfig() != null) {
            managers[0] = this.getConfig();
            return managers;
        }
        return new PrintJobConfig[0];
    }

    @Override
    public void setPageConfig(IPrintJob job) {
        this.getConfig().set(job.getConfig());
        this.checkChange();
    }

    @Override
    public void setID(String name) {
        this.id = name;
    }

    public void fireBeginGetPage() {
        for (IBeforePaginationListener listener : this.beginGetPageListeners) {
            listener.beforePagination(this.getID());
        }
    }

    @Override
    public void addBeforePaginationListener(IBeforePaginationListener listener) {
        if (listener != null) {
            this.beginGetPageListeners.add(listener);
        }
    }

    @Override
    public boolean isDynamicPaper() {
        return this.getConfig().isDynamicPaper();
    }

    public void setDynamicPaper(boolean isDynamicpaper) {
        this.getConfig().setDynamicPaper(isDynamicpaper);
    }

    @Override
    public IVariantParser getVariantParser() {
        return this.variantParser;
    }

    @Override
    public void setVariantParser(IVariantParser variantParser) {
        this.variantParser = variantParser;
    }

    @Override
    public void addPrintJob(IPrintJob onePrint) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public IPrintJob getPrintJob(int index) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public IPrintJob getPrintJobByPaperIndex(int paperIndex) {
        return this;
    }

    @Override
    public void preparePagination() {
        this.clear();
        this.update();
    }

    @Override
    public void setUserObject(Object obj) {
        this.userObj = obj;
    }

    @Override
    public Object getUserObject() {
        return this.userObj;
    }

    public void bufferPrint() {
    }

    public String toString() {
        return this.id;
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public Paper getTestPaper(boolean testType) {
        this.update();
        Paper paper = null;
        Page page = this.getTestPage(testType);
        if (page != null) {
            paper = this.createNewPaper(0);
            page.setX(this.getPaperInfo().getPageBounds().x);
            page.setY(this.getPaperInfo().getPageBounds().y);
            paper.setBody(page);
            this.setWaterMark(paper, 0);
        }
        return paper;
    }

    public Page getTestPage(boolean testType) {
        return null;
    }

    @Override
    public int pageDialog(Component owner, boolean isShowPreviewButton) {
        return 0;
    }

    @Override
    public int pageDialog2(Component owner, boolean isShowPreviewButton) {
        return 0;
    }
}

