/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.list.FileBasedList;
import kd.bos.print.core.ctrl.common.util.list.exception.OutOfCapacityException;
import kd.bos.print.core.ctrl.print.util.TempFileUtil;
import kd.bos.print.core.model.ui.io.Painter2Xml;
import kd.bos.print.core.model.ui.io.Xml2Painter;

public class PrintPageFileBuffer
extends FileBasedList {
    private int memoryBuffercount = 10;
    private List pageCache = new ArrayList();
    private Map styles = new HashMap();
    private Painter2Xml toXml = new Painter2Xml(this.styles);
    private Xml2Painter fromXml = new Xml2Painter(this.styles);
    private static final Log log = LogFactory.getLog(PrintPageFileBuffer.class);

    public PrintPageFileBuffer(int memoryCount) throws IOException {
        super(-1, false);
        this.memoryBuffercount = memoryCount;
    }

    private void createBufferFile() throws IOException {
        if (this.randomFile == null) {
            File bufferFile = TempFileUtil.createPrintTempFile();
            this.filePath = bufferFile.getAbsolutePath();
            if (this.filePath.contains("\\")) {
                this.filePath = this.filePath.replace('\\', '/');
                bufferFile = new File(this.filePath);
            }
            if (!bufferFile.getParentFile().exists()) {
                bufferFile.getParentFile().mkdirs();
            }
            this.randomFile = new RandomAccessFile(bufferFile, "rws");
            this.randomFile.setLength(0L);
        }
    }

    @Override
    public Object get(int index) {
        if (index < this.memoryBuffercount) {
            return this.pageCache.get(index);
        }
        return super.get(index - this.memoryBuffercount);
    }

    @Override
    public void add(int index, Object obj) throws OutOfCapacityException {
        if (index < this.memoryBuffercount) {
            this.pageCache.add(index, obj);
            return;
        }
        try {
            this.createBufferFile();
            super.add(index - this.memoryBuffercount, obj);
        }
        catch (IOException e) {
            throw new OutOfCapacityException();
        }
    }

    @Override
    public void add(Object obj) throws OutOfCapacityException {
        this.add(this.size(), obj);
    }

    @Override
    public int size() {
        return this.pageCache.size() + super.size();
    }

    @Override
    public void clear() {
        this.pageCache.clear();
        this.styles.clear();
        super.clear();
    }

    public Map getStyles() {
        return this.styles;
    }
}

