/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.common.designercore.data;

import kd.bos.print.core.ctrl.common.DataType;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.data.meta.MetaField;

public class Field {
    private MetaField _mf;

    public static Field valueOf(String name, String alias) {
        Field f = new Field();
        f.setName(name);
        f.setAlias(alias);
        return f;
    }

    protected MetaField getMf() {
        if (this._mf == null) {
            this._mf = new MetaField();
        }
        return this._mf;
    }

    public void setName(String name) {
        this.getMf().setName(name);
    }

    public String getName() {
        return this.getMf().getName();
    }

    public void setAlias(String alias) {
        this.getMf().setAlias(alias);
    }

    public String getAlias() {
        return this.getMf().getAlias();
    }

    public DataType getDataType() {
        return this.getMf().getType();
    }

    public String getAliasName() {
        return this.getMf().getAliasName();
    }

    public String toString() {
        return this.innerToString(true);
    }

    private String innerToString(boolean aliasWithName) {
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isEmptyString((String)this.getName())) {
            sb.append("Null");
        } else if (StringUtil.isEmptyString((String)this.getAlias())) {
            sb.append(this.getName());
        } else {
            sb.append(this.getAlias());
            if (aliasWithName) {
                sb.append(" ( ");
                sb.append(this.getName());
                sb.append(" )");
            }
        }
        return sb.toString();
    }

    public String toDrawString() {
        StringBuilder sb = new StringBuilder("$F{");
        sb.append(this.innerToString(false));
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object another) {
        if (another instanceof Field) {
            Field f = (Field)another;
            if (StringUtil.equals((String)this.getName(), (String)f.getName()) && StringUtil.equals((String)this.getAlias(), (String)f.getAlias())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        if (this.getAlias() != null) {
            result = this.getAlias().hashCode();
        }
        result = result * 31 + this.getName().hashCode();
        return result;
    }

    public static boolean equals(Field f1, Field f2) {
        if (f1 == null) {
            return f2 == null;
        }
        return f1.equals(f2);
    }

    public static Field fromMetaField(MetaField mf) {
        Field f = new Field();
        f.getMf().copy(mf);
        f.getMf().setType(mf.getType());
        f.getMf().setExpr(mf.getExpr());
        return f;
    }

    public MetaField toMetaField() {
        MetaField mf = new MetaField();
        mf.copy(this.getMf());
        mf.setType(this.getMf().getType());
        mf.setExpr(this.getMf().getExpr());
        return mf;
    }
}

