/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.form.engine.x.common;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.exception.CircularReferenceException;
import kd.bos.print.core.ctrl.reportone.r1.form.engine.x.util.ListUtil;

public abstract class ARelationalNode {
    private static final Log log = LogFactory.getLog(ARelationalNode.class);
    public static final int STATE_SURE = 0;
    public static final int STATE_UNSURE = 1;
    public static final int STATE_CRITICAL = 2;
    public static final int STATE_SURE_SELF = 3;
    private int state = 0;
    private List prepNodes;
    private List postNodes;

    public final boolean isRoot() {
        return this.prepNodes == null;
    }

    private int getState() {
        return this.state;
    }

    private void setState(int state) {
        this.state = state;
    }

    public final void setPostNode(ARelationalNode x) {
        this.putPostNode(x);
        x.putPrepNode(this);
    }

    public final void setPrepNode(ARelationalNode x) {
        this.putPrepNode(x);
        x.putPostNode(this);
    }

    public final ARelationalNode getPrepNode() {
        return this.prepNodes == null || this.prepNodes.size() == 0 ? null : (ARelationalNode)this.prepNodes.get(this.prepNodes.size() - 1);
    }

    private void putPostNode(ARelationalNode x) {
        if (this.postNodes == null) {
            this.postNodes = new ArrayList();
            this.postNodes.add(x);
        } else {
            ListUtil.putItem(this.postNodes, x);
        }
    }

    private void putPrepNode(ARelationalNode x) {
        if (this.prepNodes == null) {
            this.prepNodes = new ArrayList();
            this.prepNodes.add(x);
        } else {
            ListUtil.putItem(this.prepNodes, x);
        }
    }

    private void unsure(Object arg) {
        this.setState(1);
        if (this.postNodes != null) {
            int z = this.postNodes.size();
            block4: for (int i = 0; i < z; ++i) {
                ARelationalNode post = (ARelationalNode)this.postNodes.get(i);
                switch (post.getState()) {
                    case 0: {
                        post.unsure(arg);
                        continue block4;
                    }
                    case 1: {
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    private void ensurePrepNodes(Object arg) {
        int z = this.prepNodes.size();
        block4: for (int i = 0; i < z; ++i) {
            ARelationalNode prep = (ARelationalNode)this.prepNodes.get(i);
            switch (prep.getState()) {
                case 1: {
                    this.ensurePrepNode(prep, arg);
                    continue block4;
                }
                case 0: 
                case 3: {
                    continue block4;
                }
                default: {
                    throw new CircularReferenceException("Node:" + prep.toString());
                }
            }
        }
    }

    private void ensurePostNodes(Object arg) {
        int z = this.postNodes.size();
        block3: for (int i = 0; i < z; ++i) {
            ARelationalNode post = (ARelationalNode)this.postNodes.get(i);
            switch (post.getState()) {
                case 1: 
                case 3: {
                    this.ensurePostNode(post, arg);
                    continue block3;
                }
            }
        }
    }

    protected abstract void ensureThisNode(Object var1);

    protected void ensurePrepNode(ARelationalNode prep, Object arg) {
        prep.ensure(false, arg);
    }

    protected void ensurePostNode(ARelationalNode post, Object arg) {
        post.ensure(true, arg);
    }

    private void ensure(boolean isAll, Object arg) {
        switch (this.getState()) {
            case 1: {
                this.setState(2);
                if (this.prepNodes != null) {
                    this.ensurePrepNodes(arg);
                }
                this.ensureThisNode(arg);
                this.setState(3);
                if (isAll || this.postNodes != null) break;
                this.setState(0);
                break;
            }
            case 3: {
                if (this.postNodes != null) {
                    this.ensurePostNodes(arg);
                }
                this.setState(0);
                break;
            }
        }
    }

    public final void change(Object arg) {
        this.unsure(arg);
        this.ensure(true, arg);
    }
}

