/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.form.engine.x.common;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.ctrl.exception.ConfigException;
import kd.bos.print.core.ctrl.exception.NewObjectException;
import kd.bos.print.core.ctrl.exception.UnsupportedException;
import kd.bos.print.core.ctrl.reportone.r1.form.engine.x.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ObjFactory {
    private static final String T_NODE = "Node";
    private static final String A_TYPE = "type";
    private static final String A_CLASS = "class";
    private Map type2class;

    public void loadTypesConfig(String filePath) {
        try {
            Element xmlNodes = XmlUtil.readXmlFile(filePath);
            this.parseTypes(xmlNodes);
        }
        catch (Exception ex) {
            ConfigException.makeException("Types defined error", ex);
        }
    }

    public void loadTypesConfig(InputStream in) {
        if (in == null) {
            throw new ConfigException("Types stream is null");
        }
        try {
            Element xmlNodes = XmlUtil.readXmlStream(in);
            this.parseTypes(xmlNodes);
        }
        catch (Exception ex) {
            ConfigException.makeException("Types defined error", ex);
        }
    }

    public void parseTypes(Element xmlNodes) {
        NodeList nl = xmlNodes.getElementsByTagName(T_NODE);
        this.type2class = new HashMap(nl.getLength());
        int z = nl.getLength();
        for (int i = 0; i < z; ++i) {
            Element xmlNode = (Element)nl.item(i);
            String type = xmlNode.getAttribute(A_TYPE);
            String clsName = xmlNode.getAttribute(A_CLASS);
            this.type2class.put(type, clsName);
        }
    }

    public boolean isType(String type) {
        if (this.type2class == null) {
            return false;
        }
        return this.type2class.containsKey(type);
    }

    public Object newObject(String type) {
        if (this.type2class == null) {
            throw new ConfigException("Types config not loaded!");
        }
        Object v = this.type2class.get(type);
        if (v == null) {
            throw new UnsupportedException("Undefined type:" + type);
        }
        try {
            Class<?> cls;
            if (v instanceof String) {
                cls = Class.forName((String)v);
                this.type2class.put(type, cls);
            } else {
                cls = (Class<?>)v;
            }
            return cls.newInstance();
        }
        catch (Exception ex) {
            throw NewObjectException.makeException("Type:" + type, ex);
        }
    }
}

