/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.common;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.ctrl.reportone.r1.print.common.PunctuationMuster;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.model.ui.view.StyleRender;

public class AdjustHeightRenderer {
    public static void draw(Graphics graphics, Rectangle rect, String text, Style style) {
        Result result = AdjustHeightRenderer.drawing(null, text, style, 0, rect.height, rect.width, 0);
        int offsetY = style.getVerticalAlign() == Styles.VerticalAlignment.TOP ? 0 : (style.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE ? (rect.height - result.getUsedHeight()) / 2 : rect.height - result.getUsedHeight());
        AdjustHeightRenderer.drawing(graphics, text, style, 0, rect.height + offsetY, rect.width, offsetY);
    }

    public static Result adjustHeight(String text, Style style, int minH, int maxH, int width) {
        Rectangle rect = StyleRender.getContentBounds((int)width, (int)minH, (Style)style);
        width = rect.width;
        minH = rect.height;
        rect = StyleRender.getContentBounds((int)width, (int)maxH, (Style)style);
        maxH = rect.height;
        Result result = AdjustHeightRenderer.drawing(null, text, style, minH, maxH, width, 0);
        Rect padding = style.getPadding();
        int top = padding.getTop();
        int bottom = padding.getBottom();
        if (style != null) {
            top += style.getBorderLineStyle(Styles.Position.TOP).getWidth();
            bottom += style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth();
        }
        Result result2 = result;
        result2.usedHeight = result2.usedHeight + (top + bottom);
        return result;
    }

    private static Result drawing(Graphics graphics, String text, Style style, int minH, int maxH, int width, int offsetY) {
        if (width <= 0) {
            return Result.create(minH, 0, 0, true);
        }
        Font font = AdjustHeightRenderer.createFont(style, style.getKDFont().getSize2D());
        if (font == null) {
            font = style.getFont();
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int lineSpacing = Util.pound2Pixel((int)((int)style.getLinespacing()));
        int wordSpacing = Util.pound2Pixel((int)((int)style.getWordspacing()));
        Graphics g = null;
        if (graphics != null) {
            g = graphics.create(style.getPadding().getLeft(), style.getPadding().getTop(), width, maxH);
            g.setColor(style.getFontColor());
            Font font2 = AdjustHeightRenderer.createFont(style, style.getKDFont().getSize2D());
            g.setFont(font2);
        }
        int x = 0;
        int y = fontMetrics.getAscent() + offsetY;
        int length = text.length();
        int lineFirstCharIndex = 0;
        boolean forceEnter = false;
        boolean isOnlyOneLine = true;
        for (int i = 0; i < length; ++i) {
            char aChar = text.charAt(i);
            int tempX = 0;
            int nextRowStart = i;
            int charWidth = fontMetrics.charWidth(aChar);
            int moveIndex = 0;
            if (charWidth == 0) {
                if (aChar == '\n') {
                    tempX = width + 1;
                    forceEnter = true;
                } else {
                    tempX = x;
                }
                ++nextRowStart;
            } else {
                tempX = x + charWidth;
            }
            if (tempX > width) {
                if (forceEnter) {
                    AdjustHeightRenderer.drawLineText(g, text.substring(lineFirstCharIndex, i), y, style, width, true);
                    forceEnter = false;
                    lineFirstCharIndex = i;
                } else {
                    i = moveIndex = PunctuationMuster.cutIndex(i, lineFirstCharIndex, text, fontMetrics, wordSpacing, width);
                    int textWidth = 0;
                    for (int k = 0; k < text.substring(lineFirstCharIndex, i).length(); ++k) {
                        int cw = fontMetrics.charWidth(text.substring(lineFirstCharIndex, i).charAt(k));
                        if (cw == 0) continue;
                        textWidth += cw;
                    }
                    if (textWidth <= width) {
                        AdjustHeightRenderer.drawLineText(g, text.substring(lineFirstCharIndex, i), y, style, width, false);
                        lineFirstCharIndex = i;
                    } else {
                        AdjustHeightRenderer.drawLineText(g, text.substring(lineFirstCharIndex, i - 1), y, style, width, false);
                        lineFirstCharIndex = i - 1;
                    }
                }
                nextRowStart = i;
                if (y + fontMetrics.getHeight() + fontMetrics.getDescent() + lineSpacing > maxH) {
                    if (isOnlyOneLine && y + fontMetrics.getDescent() > maxH) {
                        return Result.create(maxH, 0, length, true);
                    }
                    return Result.create(maxH, nextRowStart, length, false);
                }
                if (i != length - 1) {
                    y += lineSpacing;
                }
                x = 0;
                tempX = charWidth;
                y += fontMetrics.getHeight() + 1;
                isOnlyOneLine = false;
            }
            if (i == length - 1) {
                AdjustHeightRenderer.drawLineText(g, text.substring(lineFirstCharIndex, length), y, style, width, true);
            }
            if (charWidth <= 0) continue;
            x = tempX + wordSpacing;
        }
        if ((y += fontMetrics.getDescent()) > maxH) {
            y = maxH;
            if (isOnlyOneLine) {
                return Result.create(y, 0, length, true);
            }
        }
        return Result.create(y < minH ? minH : y, length, length, false);
    }

    private static Font createFont(Style style, float fontSize) {
        int boldAndItalic = 0;
        boldAndItalic += style.isBold() ? 1 : 0;
        return KDFont.loadFontFromJAR((String)style.getFontName(), (int)(boldAndItalic += style.isItalic() ? 2 : 0), (float)fontSize);
    }

    private static void drawLineText(Graphics g, String drawText, int y, Style style, int width, boolean isLastLine) {
        if (g != null) {
            int i;
            Font font = g.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int wordSpace = Util.pound2Pixel((int)((int)style.getWordspacing()));
            int x = 0;
            int[] wordsSpace = new int[]{wordSpace, 0};
            int textWidth = 0;
            int charNumber = 0;
            for (i = 0; i < drawText.length(); ++i) {
                int charWidth = fontMetrics.charWidth(drawText.charAt(i));
                if (charWidth == 0) continue;
                ++charNumber;
                textWidth += charWidth;
            }
            if (style.getHorizontalAlign() == Styles.HorizontalAlignment.CENTER) {
                x = (width - textWidth - (charNumber - 1) * wordSpace) / 2;
            } else if (style.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
                x = width - textWidth - (charNumber - 1) * wordSpace;
            }
            if (style.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT || x < 0) {
                x = 1;
            }
            for (i = 0; i < drawText.length(); ++i) {
                char nowChar = drawText.charAt(i);
                if (style.isUnderline()) {
                    AttributedString attributedString = new AttributedString(String.valueOf(nowChar));
                    attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    g.drawString(attributedString.getIterator(), x, y);
                } else {
                    g.drawString(String.valueOf(nowChar), x, y);
                }
                if (fontMetrics.charWidth(nowChar) == 0) continue;
                if (i <= wordsSpace[1] - 1) {
                    ++x;
                }
                x += fontMetrics.charWidth(nowChar) + wordsSpace[0];
            }
        }
    }

    public static class Result {
        private int usedHeight;
        private int cutPosition;
        private boolean isCutOff;
        private boolean isThrowAwayField;

        public static Result create(int usedH, int cutPos, int textLength, boolean isThrowAwayField) {
            Result result = new Result();
            result.usedHeight = usedH;
            result.cutPosition = cutPos;
            result.isCutOff = cutPos != textLength;
            result.isThrowAwayField = isThrowAwayField;
            return result;
        }

        public int getUsedHeight() {
            return this.usedHeight;
        }

        public boolean isTextCutOff() {
            return this.isCutOff;
        }

        public int getCutPosition() {
            return this.cutPosition;
        }

        public boolean isThrowAway() {
            return this.isThrowAwayField;
        }
    }
}

