/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.common;

import java.awt.FontMetrics;
import kd.bos.dataentity.utils.ArrayUtils;

public class PunctuationMuster {
    static char[] _lineInLast = new char[]{',', '.', ';', ':', '?', '!', '>', ')', '}', '-', ']', '\u2026', '\uff0c', '\u3002', '\uff1b', '\uff1a', '\uff1f', '\uff01', '\u300b', '\uff09', '\uff5d', '\u2014', '\u3011', '\u201d', '\u2019', '\u00d7'};
    static char[] _lineInBefore = new char[]{'<', '(', '[', '{', '\u300a', '\uff08', '\u3010', '\uff5b', '\u2018', '\u201c', '\n'};
    private static int beforePunctua = 1;
    private static int afterPunctua = 16;
    private static int other = 17;

    private static int getType(char text) {
        int i;
        for (i = 0; i < _lineInBefore.length; ++i) {
            if (_lineInBefore[i] != text) continue;
            return beforePunctua;
        }
        for (i = 0; i < _lineInLast.length; ++i) {
            if (_lineInLast[i] != text) continue;
            return afterPunctua;
        }
        return other;
    }

    public static int cutIndex(int nextLineFirst, int lineFirst, String text, FontMetrics fontMetrics, int wordSpace, int width) {
        int realIndex;
        int i;
        if (PunctuationMuster.isCanCut(nextLineFirst, text, fontMetrics)) {
            int realIndex2 = nextLineFirst;
            if (PunctuationMuster.isInWord(text, nextLineFirst)) {
                realIndex2 = PunctuationMuster.getPreWordBreak(nextLineFirst, lineFirst, text);
            }
            return realIndex2;
        }
        if (wordSpace > 0) {
            int up = 0;
            for (i = nextLineFirst + 1; i < text.length(); ++i) {
                if (!PunctuationMuster.isCanCut(i, text, fontMetrics)) continue;
                realIndex = i;
                if (PunctuationMuster.isInWord(text, nextLineFirst)) {
                    realIndex = PunctuationMuster.getPreWordBreak(nextLineFirst, lineFirst, text);
                }
                up = realIndex - nextLineFirst;
                break;
            }
            if (up > 0) {
                String drawText = text.substring(lineFirst, nextLineFirst + up - 1);
                int textWidth = 0;
                int charNumber = 0;
                for (int i2 = 0; i2 < drawText.length(); ++i2) {
                    int charWidth = fontMetrics.charWidth(drawText.charAt(i2));
                    if (charWidth == 0) continue;
                    ++charNumber;
                    textWidth += charWidth;
                }
                int[] newWordSpace = PunctuationMuster.getWordsSpace(width, textWidth, charNumber);
                if ((double)(newWordSpace[0] / wordSpace) >= 0.8) {
                    return up + nextLineFirst;
                }
            }
        }
        int down = 0;
        for (i = nextLineFirst - 1; lineFirst < i; --i) {
            if (!PunctuationMuster.isCanCut(i, text, fontMetrics)) continue;
            realIndex = i;
            down = nextLineFirst - realIndex;
            break;
        }
        return nextLineFirst - down;
    }

    private static boolean isCanCut(int index, String text, FontMetrics fontMetrics) {
        int beforeCharWidth;
        int charWidth = fontMetrics.charWidth(text.charAt(index));
        if (charWidth == 0) {
            return false;
        }
        char beforeChar = ' ';
        for (int i = index - 1; 0 <= i && (beforeCharWidth = fontMetrics.charWidth(beforeChar = (char)text.charAt(i))) == 0; --i) {
            if (beforeCharWidth != 10) continue;
            return true;
        }
        int type = PunctuationMuster.getType(text.charAt(index));
        int beforeType = PunctuationMuster.getType(beforeChar);
        if (type != afterPunctua) {
            return beforeType != beforePunctua;
        }
        return false;
    }

    public static int[] getWordsSpace(int width, int textWidth, int charNumber) {
        if (charNumber <= 1) {
            return new int[]{0, 0};
        }
        int newWordSpace = (width - textWidth) / (charNumber - 1);
        int addOneNumber = (width - textWidth) % (charNumber - 1);
        int[] newWordsSpace = new int[]{newWordSpace, addOneNumber};
        return newWordsSpace;
    }

    private static int getPreWordBreak(int fromIndex, int lineFirst, String text) {
        for (int i = fromIndex - 1; i > lineFirst; --i) {
            if (PunctuationMuster.isInWord(text, i)) continue;
            return i + 1;
        }
        return fromIndex - 1;
    }

    private static boolean isInWord(String text, int index) {
        if (index <= 0 || index >= text.length()) {
            return false;
        }
        char c = text.toCharArray()[index];
        if (ArrayUtils.contains((char[])_lineInBefore, (char)c) || ArrayUtils.contains((char[])_lineInLast, (char)c)) {
            return true;
        }
        if (c < '0' || c > '9' && c < '@' || c > 'z' || c < '\u4e00' || c > '\u9fbb') {
            return false;
        }
        c = text.toCharArray()[index - 1];
        if (ArrayUtils.contains((char[])_lineInBefore, (char)c) || ArrayUtils.contains((char[])_lineInLast, (char)c)) {
            return true;
        }
        return c >= '0' && (c <= '9' || c >= '@') && c <= 'z' && c >= '\u4e00' && c <= '\u9fbb';
    }
}

