/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.common;

import java.awt.Graphics;
import java.awt.Rectangle;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.ComplexTextRenderer;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.DivideCharacterRenderer;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.IDivideCharacterSupport;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.AdjustHeightRenderer;
import kd.bos.print.core.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import kd.bos.print.core.model.ui.component.IRender;

public class R1PrintStringRender
implements IRender {
    private static final Log log = LogFactory.getLog(R1PrintStringRender.class);
    private static R1PrintStringRender shareInst;
    private ComplexTextRenderer complexTextRenderer;

    public static synchronized R1PrintStringRender getInstance() {
        if (shareInst == null) {
            shareInst = new R1PrintStringRender();
            R1PrintStringRender.shareInst.complexTextRenderer = new ComplexTextRenderer();
        }
        return shareInst;
    }

    public void drawText(Graphics g, Rectangle rect, String text, Style style, Object targetObj) {
        if (((IAdjustHeightRenderSupport)targetObj).isUseAdjustHeightRender() && targetObj instanceof IAdjustHeightRenderSupport && StringUtils.isNotBlank((CharSequence)text)) {
            int divideCharNums = -1;
            if (targetObj instanceof IDivideCharacterSupport) {
                divideCharNums = ((IDivideCharacterSupport)targetObj).getDivideCharNums();
            }
            if (divideCharNums > 0) {
                boolean isDrawBorder = false;
                if (style != null) {
                    isDrawBorder = !style.getBorderLineStyle(Styles.Position.LEFT).isNullBorder();
                }
                DivideCharacterRenderer renderer = DivideCharacterRenderer.shareInstance((int)divideCharNums, (boolean)isDrawBorder);
                String drawText = "";
                if (text != null) {
                    drawText = text;
                }
                renderer.draw(g, rect, drawText, style, targetObj);
            } else {
                AdjustHeightRenderer.draw(g, rect, text, style);
            }
            return;
        }
        int divideCharNums = -1;
        if (targetObj instanceof IDivideCharacterSupport) {
            divideCharNums = ((IDivideCharacterSupport)targetObj).getDivideCharNums();
        }
        if (divideCharNums > 0) {
            boolean isDrawBorder = false;
            if (style != null) {
                isDrawBorder = !style.getBorderLineStyle(Styles.Position.LEFT).isNullBorder();
            }
            DivideCharacterRenderer renderer = DivideCharacterRenderer.shareInstance((int)divideCharNums, (boolean)isDrawBorder);
            String drawText = "";
            if (text != null) {
                drawText = text;
            }
            renderer.draw(g, rect, drawText, style, targetObj);
        } else if (!StringUtil.isEmptyString((String)text)) {
            this.complexTextRenderer.draw(g, rect, text, style);
        }
    }
}

