/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.common.gridcompute;

import java.util.HashMap;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;

public class Oper {
    public static final Oper ADD = new Oper("+", 1);
    public static final Oper MINUS = new Oper("-", 1);
    public static final Oper MULTIPLY = new Oper("*", 2);
    public static final Oper DIVIDE = new Oper("/", 2);
    private static HashMap ALL = new HashMap();
    private String _key;
    private int _priority;

    public static Oper fromString(String str) {
        Oper oper = (Oper)ALL.get(str);
        if (oper == null) {
            throw new R1PrintRuntimeException("The operater is not supported.");
        }
        return oper;
    }

    private Oper(String key, int priority) {
        this._key = key;
        this._priority = priority;
    }

    public int getPriority() {
        return this._priority;
    }

    public String getOperString() {
        return this._key;
    }

    public String toString() {
        return this.getOperString();
    }

    public Variant computing(Variant leftValue, Variant rightValue) throws SyntaxErrorException {
        if (!leftValue.isNumeric() || !rightValue.isNumeric()) {
            return leftValue;
        }
        Variant result = new Variant(0);
        if (StringUtil.equals((String)"+", (String)this._key)) {
            leftValue.add(rightValue, result);
        } else if (!StringUtil.equals((String)"-", (String)this._key) && !StringUtil.equals((String)"*", (String)this._key)) {
            if (StringUtil.equals((String)"/", (String)this._key)) {
                if (rightValue.doubleValue() != 0.0) {
                    leftValue.divide(rightValue, result);
                }
            } else {
                throw new R1PrintRuntimeException("Error operate type.");
            }
        }
        return result;
    }

    static {
        ALL.put(ADD.getOperString(), ADD);
        ALL.put(MINUS.getOperString(), MINUS);
        ALL.put(MULTIPLY.getOperString(), MULTIPLY);
        ALL.put(DIVIDE.getOperString(), DIVIDE);
    }
}

