/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.engine;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.field.Field;

public class ScriptSystemMethod {
    private IWidgetExecuteHelper _executeHelper;
    private HashMap _variant;
    private static final String NOW2DATE = "@@nowDate##";

    public void setExecuteHelper(IWidgetExecuteHelper helper) {
        this._executeHelper = helper;
    }

    private HashMap getVariant() {
        if (this._variant == null) {
            this._variant = new HashMap();
        }
        return this._variant;
    }

    public void set(String name, Object value) {
        this.getVariant().put(name, value);
    }

    public Object get(String name) {
        return this.getVariant().get(name);
    }

    public Object now2() {
        Object date = this.getVariant().get(NOW2DATE);
        if (null == date && date == null) {
            date = new Date();
        }
        return date;
    }

    public String format(Object value, String formatString) {
        Variant var = new Variant(value);
        FormatResult fmtResult = Formats.getFormat((String)formatString).format(var);
        String strResult = fmtResult.toString();
        return strResult;
    }

    public String formatChequeDate(Object value, String formatString) {
        return this.formatChequeDate(value, formatString, 1);
    }

    public String formatChequeDate(Object value, String formatString, int mode) {
        boolean toDealDay;
        Calendar t;
        String prefix;
        if (value == null) {
            return "";
        }
        if (mode == 0) {
            prefix = "[DBNum5]";
        } else if (mode == 1) {
            prefix = "[DBNum2]";
        } else {
            return "Invalid mode: " + mode;
        }
        if (!formatString.startsWith(prefix)) {
            formatString = prefix + formatString;
        }
        Variant var = new Variant(value);
        FormatResult fmtResult = Formats.getFormat((String)formatString).format(var);
        String strResult = fmtResult.toString();
        try {
            t = var.toCalendar();
        }
        catch (SyntaxErrorException e) {
            return strResult;
        }
        int month = t.get(2) + 1;
        int day = t.get(5);
        boolean toDealMonth = month == 10;
        boolean bl = toDealDay = day == 10 || day == 20 || day == 30;
        if (!toDealMonth && !toDealDay) {
            return strResult;
        }
        boolean haveMonth = formatString.indexOf("mm") != -1;
        boolean haveDay = formatString.indexOf("dd") != -1;
        int idxMonthStart = -1;
        if (haveMonth) {
            FormatResult tempResult = Formats.getFormat((String)(prefix + "mm")).format(new Variant((Object)("2007-" + month + "-1")));
            String strTempResult = tempResult.toString();
            idxMonthStart = strResult.indexOf(strTempResult);
        }
        int idxDayStart = -1;
        if (haveDay) {
            FormatResult tempResult = Formats.getFormat((String)(prefix + "dd")).format(new Variant((Object)("2007-1-" + day)));
            String strTempResult = tempResult.toString();
            idxDayStart = strResult.lastIndexOf(strTempResult);
        }
        StringBuilder sbNewResult = new StringBuilder(strResult);
        if (idxDayStart != -1 && toDealDay) {
            sbNewResult.insert(idxDayStart, ResManager.loadKDString((String)"\u96f6", (String)"ScriptSystemMethod_0", (String)"bos-print-core", (Object[])new Object[0]));
        }
        if (idxMonthStart != -1 && toDealMonth) {
            sbNewResult.insert(idxMonthStart, ResManager.loadKDString((String)"\u96f6", (String)"ScriptSystemMethod_0", (String)"bos-print-core", (Object[])new Object[0]));
        }
        return sbNewResult.toString();
    }

    public String formatChequeCurrency(Object value) {
        return this.formatChequeCurrency(value, '\uffe5', 1);
    }

    public String formatChequeCurrency(Object value, char fillChar, int fillMode) {
        int fillCount;
        Variant var = new Variant(value);
        FormatResult fmtRst = Formats.getFormat((String)"[DBNum8]0.00").format(var);
        String formated = fmtRst.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(formated.substring(0, formated.length() - 3));
        sb.append(formated.substring(formated.length() - 2));
        if (fillMode == 1) {
            sb.insert(0, fillChar);
        } else if (fillMode >= 2 && (fillCount = fillMode - sb.length()) > 0) {
            for (int i = 0; i < fillCount; ++i) {
                sb.insert(0, fillChar);
            }
        }
        return sb.toString();
    }

    public Object getFieldValue(String ds, String field) {
        Field var = this._executeHelper.getDataHelper().getFieldValue(ds, field);
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    public String repeatString(String source, int times) {
        return StringUtil.makeRepeatString((String)source, (int)times);
    }

    public String leftString(String src, int len) {
        if (len < 0) {
            len = 0;
        }
        if (len > src.length()) {
            len = src.length();
        }
        return src.substring(0, len);
    }

    public String rightString(String src, int len) {
        int start;
        if (len < 0) {
            len = 0;
        }
        if ((start = src.length() - len) < 0) {
            start = 0;
        }
        return src.substring(start);
    }

    public String middleString(String src, int start, int len) {
        int end = (start = start < 0 ? 0 : start) + (len = len < 0 ? 0 : len);
        if (end > src.length()) {
            end = src.length();
        }
        return src.substring(start, end);
    }

    public String replaceString(String src, String sub, String newSub) {
        StringBuilder result = new StringBuilder();
        int subLen = sub.length();
        int last = 0;
        if (subLen > 0) {
            int found = 0;
            while (found >= 0) {
                found = src.indexOf(sub, last);
                if (found < 0) continue;
                result.append(src.substring(last, found));
                result.append(newSub);
                last = found + subLen;
            }
        }
        result.append(src.substring(last));
        return result.toString();
    }

    private int innerDateGet(Object value, int key) {
        Calendar cal;
        Variant var = new Variant(value);
        try {
            cal = var.toCalendar();
        }
        catch (SyntaxErrorException e) {
            return -1;
        }
        return cal.get(key);
    }

    public int year(Object value) {
        return this.innerDateGet(value, 1);
    }

    public int month(Object value) {
        return this.innerDateGet(value, 2) + 1;
    }

    public int day(Object value) {
        return this.innerDateGet(value, 5);
    }

    public int hour(Object value) {
        return this.innerDateGet(value, 11);
    }

    public int minute(Object value) {
        return this.innerDateGet(value, 12);
    }

    public int second(Object value) {
        return this.innerDateGet(value, 13);
    }

    public int week(Object value) {
        return this.innerDateGet(value, 7);
    }
}

