/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.script.miniscript;

import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.ctrl.script.miniscript.ScriptResult;
import kd.bos.print.core.ctrl.script.miniscript.exec.IVarRequestor;
import kd.bos.print.core.ctrl.script.miniscript.exec.SystemObject;
import kd.bos.print.core.ctrl.script.miniscript.exec.objs.Var;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.MiniScript;

public class ScriptContext {
    public static final int INIT_LEVEL = 0;
    public static final int UNLIMIT_LEVEL = Integer.MAX_VALUE;
    public static final String INNER_RET_VAR_PREFIX = "__$RET__";
    private String script;
    private MiniScript MiniScript;
    private ScriptResult scriptResult;
    private Map systemMap = new HashMap();
    private int level = 0;
    private SystemObject systemObject = null;
    private IVarRequestor varRequestor = null;

    public ScriptContext() {
        this.initContext();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int incLevel() {
        return ++this.level;
    }

    public int decLevel() {
        --this.level;
        Map varMap = this.scriptResult.getVarMap();
        HashMap<Var, Object> newMap = new HashMap<Var, Object>();
        for (Var v : varMap.keySet()) {
            if ((v = v.removeByLevel(this.level)) == null) continue;
            newMap.put(v, v.getValue());
        }
        if (newMap.size() > 0) {
            varMap.clear();
            varMap.putAll(newMap);
        }
        return this.level;
    }

    private void initContext() {
        this.scriptResult = new ScriptResult(this);
        this.systemObject = new SystemObject(this);
        this.setSystemVar("sys", (Object)this.systemObject);
        this.setSystemVar("system", System.class);
    }

    public void setSystemObject(SystemObject systemObject) {
        this.systemObject = systemObject;
        this.setSystemVar("sys", (Object)systemObject);
    }

    public SystemObject getSystemObject() {
        return this.systemObject;
    }

    public Object delSystemVar(String varName) {
        return this.delSystemVar(Var.parse(varName, this.level));
    }

    public Object delSystemVar(Var var) {
        return this.systemMap.remove(var);
    }

    public Object setSystemVar(String varName, Object value) {
        return this.setSystemVar(Var.parse(varName, this.level), value);
    }

    public Object getSystemVar(Var var) {
        if (this.existSystemVar(var)) {
            return var.getLeveledValue(this.systemMap, this.level);
        }
        if (this.varRequestor != null && !var.getName().startsWith(INNER_RET_VAR_PREFIX) && this.varRequestor.existVar(var.getName())) {
            return this.varRequestor.getVar(var.getName());
        }
        return null;
    }

    public Object setSystemVar(Var var, Object value) {
        return var.setLeveledValue(value, this.systemMap, this.level);
    }

    public Object getSystemVar(String varName) {
        return this.getSystemVar(Var.parse(varName, this.level));
    }

    public void clearSystemVar() {
        this.systemMap.clear();
    }

    public boolean existSystemVar(Var var) {
        return this.systemMap.containsKey(var);
    }

    public boolean existSystemVar(String varName) {
        return this.existSystemVar(Var.parse(varName, this.level));
    }

    public MiniScript getMiniScript() {
        return this.MiniScript;
    }

    public void setMiniScript(MiniScript miniScript) {
        this.MiniScript = miniScript;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public ScriptResult getScriptResult() {
        return this.scriptResult;
    }

    public void setInputVar(Map inputVar) {
        if (inputVar != null) {
            this.scriptResult.putVarMap(inputVar);
        }
    }

    public IVarRequestor getVarRequestor() {
        return this.varRequestor;
    }

    public void setVarRequestor(IVarRequestor varRequestor) {
        this.varRequestor = varRequestor;
    }
}

