/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.script.miniscript;

import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.ctrl.script.miniscript.MiniScriptRuntimeException;
import kd.bos.print.core.ctrl.script.miniscript.ScriptContext;
import kd.bos.print.core.ctrl.script.miniscript.exec.objs.Function;
import kd.bos.print.core.ctrl.script.miniscript.exec.objs.Var;

public class ScriptResult {
    private ScriptContext ctx;
    private Map varMap = new HashMap();
    private MiniScriptRuntimeException runtimeException = null;

    protected ScriptResult(ScriptContext ctx) {
        this.ctx = ctx;
    }

    public ScriptContext getScriptContext() {
        return this.ctx;
    }

    public Function defineFunction(Function f) {
        Var v = new Var(f.getName(), this.ctx.getLevel());
        return (Function)this.setVar(v, (Object)f);
    }

    public Object setVar(Var var, Object value) {
        if (this.ctx.existSystemVar(var)) {
            // empty if block
        }
        return var.setLeveledValue(value, this.varMap, this.ctx.getLevel());
    }

    public Object getVar(Var var) {
        if (this.varMap.containsKey(var)) {
            return var.getLeveledValue(this.varMap, this.ctx.getLevel());
        }
        return this.ctx.getSystemVar(var);
    }

    public boolean exitsVar(Var var) {
        return this.varMap.containsKey(var) || this.ctx.existSystemVar(var);
    }

    public Object delVar(Var var) {
        if (this.varMap.containsKey(var)) {
            return this.varMap.remove(var);
        }
        return this.ctx.delSystemVar(var);
    }

    public Object setVar(String varName, Object value) {
        return this.setVar(Var.parse(varName, this.ctx.getLevel()), value);
    }

    public Object getVar(String varName) {
        return this.getVar(Var.parse(varName, this.ctx.getLevel()));
    }

    public boolean exitsVar(String varName) {
        return this.exitsVar(Var.parse(varName, this.ctx.getLevel()));
    }

    public Object delVar(String varName) {
        return this.delVar(Var.parse(varName, this.ctx.getLevel()));
    }

    public void clearVar() {
        this.varMap.clear();
    }

    public Map getVarMap() {
        return this.varMap;
    }

    public void putVarMap(Map<Object, Object> map) {
        for (Map.Entry<Object, Object> pair : map.entrySet()) {
            Object key = pair.getKey();
            if (key == null) continue;
            if (key instanceof String) {
                this.setVar((String)key, pair.getValue());
                continue;
            }
            if (!(key instanceof Var)) continue;
            this.setVar((Var)key, pair.getValue());
        }
    }

    public void dumpVar() {
        Map map = this.getVarMap();
        for (Var key : map.keySet()) {
            key = key.getLinkHead();
            while ((key = key.next()) != null) {
            }
        }
    }

    public MiniScriptRuntimeException getRuntimeException() {
        return this.runtimeException;
    }

    public boolean withException() {
        return this.runtimeException != null;
    }

    protected void setRuntimeException(MiniScriptRuntimeException exception) {
        this.runtimeException = exception;
    }
}

