/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.script.miniscript.exec.objs;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import kd.bos.print.core.ctrl.script.miniscript.ScriptContext;
import kd.bos.print.core.ctrl.script.miniscript.exec.ICreateObjectListener;
import kd.bos.print.core.ctrl.script.miniscript.exec.objs.ArrayDim;
import kd.bos.print.core.ctrl.script.miniscript.exec.objs.FifoStack;
import kd.bos.print.core.ctrl.script.miniscript.exec.objs.Persistent;
import kd.bos.print.core.ctrl.script.miniscript.exec.objs.Var;

public class ScriptTypeObject
implements Persistent {
    private String typeName;
    private FifoStack arguments;
    private ArrayDim arrayDimensions;
    private ScriptContext ctx;
    private ICreateObjectListener listener;

    public ScriptTypeObject(ScriptContext ctx, ICreateObjectListener listener) {
        this.ctx = ctx;
        this.listener = listener;
    }

    public Object createObject() {
        try {
            Class<?> cl = this.ctx.getSystemObject().getClassByName(this.typeName);
            ArrayList<Object> params = new ArrayList<Object>();
            if (this.arguments != null) {
                this.arguments.pop();
                while (this.arguments.size() > 0) {
                    Object p = this.arguments.pop();
                    if (")".equals(p)) continue;
                    if (p instanceof Var) {
                        p = this.ctx.getScriptResult().getVar((Var)p);
                    }
                    params.add(p);
                    this.arguments.pop();
                }
            }
            int args = params.size();
            if (this.arrayDimensions == null) {
                if (args == 0) {
                    Object obj = cl.newInstance();
                    if (this.listener != null) {
                        this.listener.onCreateObject(obj, cl.getConstructor(new Class[0]), this.ctx);
                    }
                    return obj;
                }
                Constructor<?>[] cs = cl.getConstructors();
                int n = cs.length;
                for (int i = 0; i < n; ++i) {
                    Class<?>[] pps = cs[i].getParameterTypes();
                    if (!this.ctx.getSystemObject().matchClassType(params, pps)) continue;
                    Object obj = cs[i].newInstance(params.toArray());
                    if (this.listener != null) {
                        this.listener.onCreateObject(obj, cs[i], this.ctx);
                    }
                    return obj;
                }
                throw new IllegalArgumentException(cl.getName() + " constructor arguments not matched with " + params);
            }
            if (args == 0) {
                return this.arrayDimensions.createObject(cl);
            }
            throw new IllegalArgumentException("Array declaration can not with argument!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FifoStack getArguments() {
        return this.arguments;
    }

    public void setArguments(FifoStack arguments) {
        this.arguments = arguments;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public ArrayDim getArrayDimensions() {
        return this.arrayDimensions;
    }

    public void setArrayDimensions(ArrayDim arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
    }
}

