/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.script.miniscript.parser;

import kd.bos.print.core.ctrl.script.miniscript.parser.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    private Token currentToken;
    private int[][] expectedTokenSequences;
    private String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(' ');
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
        }
        StringBuilder retval = new StringBuilder("Encountered \"");
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval.append(' ');
            }
            if (tok.kind == 0) {
                retval.append(this.tokenImage[0]);
                break;
            }
            retval.append(this.add_escapes(tok.image));
            tok = tok.next;
        }
        retval.append("\" at line ");
        retval.append(this.currentToken.next.beginLine);
        retval.append(", column ");
        retval.append(this.currentToken.next.beginColumn);
        retval.append('.');
        retval.append(this.eol);
        if (this.expectedTokenSequences.length == 1) {
            retval.append("Was expecting:");
            retval.append(this.eol);
            retval.append("    ");
        } else {
            retval.append("Was expecting one of:");
            retval.append(this.eol);
            retval.append("    ");
        }
        retval.append((CharSequence)expected);
        return retval.toString();
    }

    public boolean isSpecialConstructor() {
        return this.specialConstructor;
    }

    public void setSpecialConstructor(boolean specialConstructor) {
        this.specialConstructor = specialConstructor;
    }

    public Token getCurrentToken() {
        return this.currentToken;
    }

    public void setCurrentToken(Token currentToken) {
        this.currentToken = currentToken;
    }

    public int[][] getExpectedTokenSequences() {
        return this.expectedTokenSequences;
    }

    public void setExpectedTokenSequences(int[][] expectedTokenSequences) {
        this.expectedTokenSequences = expectedTokenSequences;
    }

    public String[] getTokenImage() {
        return this.tokenImage;
    }

    public void setTokenImage(String[] tokenImage) {
        this.tokenImage = tokenImage;
    }

    public String getEol() {
        return this.eol;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    protected String add_escapes(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        StringBuilder s = new StringBuilder();
                        s.append("0000");
                        s.append(Integer.toString(ch, 16));
                        retval.append("\\u");
                        retval.append(s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

