/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.script.miniscript.parser.visitor;

import java.util.Enumeration;
import java.util.Vector;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.AdditiveExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.AndExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ArgumentList;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Arguments;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Assignment;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.AssignmentOperator;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Block;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.BooleanLiteral;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.BreakStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.CharacterLiteral;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ConditionalAndExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ConditionalExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ConditionalOrExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ContinueStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.EmptyStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.EqualityExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ExclusiveOrExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ExitStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Expression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.FloatLiteral;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ForEachStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ForInit;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ForStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Function;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.IfStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.InclusiveOrExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.IntegerLiteral;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Literal;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.MiniScript;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.MultiplicativeExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Node;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.NodeListInterface;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.NodeToken;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.NullLiteral;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.PostfixExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.PreDecrementExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.PreIncrementExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.PrimaryExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.PrimaryPrefix;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.PrimarySuffix;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.PrimaryVariable;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.RelationalExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ReturnStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.ShiftExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.Statement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.StatementExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.StringLiteral;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.SwitchLabel;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.SwitchStatement;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.UnaryExpression;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.UnaryExpressionNotPlusMinus;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.VariableDeclarator;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.WhileStatement1;
import kd.bos.print.core.ctrl.script.miniscript.parser.syntaxtree.WhileStatement2;
import kd.bos.print.core.ctrl.script.miniscript.parser.visitor.DepthFirstVisitor;
import kd.bos.print.core.ctrl.script.miniscript.parser.visitor.FormatCommand;
import kd.bos.print.core.ctrl.script.miniscript.parser.visitor.TreeFormatterException;

public class TreeFormatter
extends DepthFirstVisitor {
    private Vector cmdQueue = new Vector();
    private boolean lineWrap;
    private int wrapWidth;
    private int indentAmt;
    private int curLine = 1;
    private int curColumn = 1;
    private int curIndent = 0;

    public TreeFormatter() {
        this(3, 0);
    }

    public TreeFormatter(int indentAmt, int wrapWidth) {
        this.indentAmt = indentAmt;
        this.wrapWidth = wrapWidth;
        this.lineWrap = wrapWidth > 0;
    }

    protected void processList(NodeListInterface n) {
        this.processList(n, null);
    }

    protected void processList(NodeListInterface n, FormatCommand cmd) {
        Enumeration e = n.elements();
        while (e.hasMoreElements()) {
            ((Node)e.nextElement()).accept(this);
            if (cmd == null || !e.hasMoreElements()) continue;
            this.cmdQueue.addElement(cmd);
        }
    }

    protected FormatCommand force() {
        return this.force(1);
    }

    protected FormatCommand force(int i) {
        return new FormatCommand(0, i);
    }

    protected FormatCommand indent() {
        return this.indent(1);
    }

    protected FormatCommand indent(int i) {
        return new FormatCommand(1, i);
    }

    protected FormatCommand outdent() {
        return this.outdent(1);
    }

    protected FormatCommand outdent(int i) {
        return new FormatCommand(2, i);
    }

    protected FormatCommand space() {
        return this.space(1);
    }

    protected FormatCommand space(int i) {
        return new FormatCommand(3, i);
    }

    protected void add(FormatCommand cmd) {
        this.cmdQueue.addElement(cmd);
    }

    @Override
    public void visit(NodeToken n) {
        Enumeration e = this.cmdQueue.elements();
        block6: while (e.hasMoreElements()) {
            FormatCommand cmd = (FormatCommand)e.nextElement();
            switch (cmd.getCommand()) {
                case 0: {
                    this.curLine += cmd.getNumCommands();
                    this.curColumn = this.curIndent + 1;
                    continue block6;
                }
                case 1: {
                    this.curIndent += this.indentAmt * cmd.getNumCommands();
                    continue block6;
                }
                case 2: {
                    if (this.curIndent < this.indentAmt) continue block6;
                    this.curIndent -= this.indentAmt * cmd.getNumCommands();
                    continue block6;
                }
                case 3: {
                    this.curColumn += cmd.getNumCommands();
                    continue block6;
                }
            }
            throw new TreeFormatterException("Invalid value in command queue.");
        }
        this.cmdQueue.removeAllElements();
        if (n.numSpecials() > 0) {
            e = n.getSpecialTokens().elements();
            while (e.hasMoreElements()) {
                NodeToken special = (NodeToken)e.nextElement();
                this.placeToken(special, this.curLine, this.curColumn);
                this.curLine = special.getEndLine() + 1;
            }
        }
        this.placeToken(n, this.curLine, this.curColumn);
        this.curLine = n.getEndLine();
        this.curColumn = n.getEndColumn();
    }

    private void placeToken(NodeToken n, int line, int column) {
        int length = n.getTokenImage().length();
        if (!this.lineWrap || n.getTokenImage().indexOf(10) != -1 || column + length <= this.wrapWidth) {
            n.setBeginColumn(column);
        } else {
            ++line;
            column = this.curIndent + this.indentAmt + 1;
            n.setBeginColumn(column);
        }
        n.setBeginLine(line);
        for (int i = 0; i < length; ++i) {
            if (n.getTokenImage().charAt(i) == '\n' && i < length - 1) {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        n.setEndLine(line);
        n.setEndColumn(column);
    }

    @Override
    public void visit(MiniScript n) {
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(Statement n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(Function n) {
        n.getNodeToken().accept(this);
        n.getNodeToken1().accept(this);
        n.getNodeToken2().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
        n.getNodeToken3().accept(this);
        n.getNodeToken4().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
        n.getNodeToken5().accept(this);
    }

    @Override
    public void visit(Block n) {
        n.getNodeToken().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
        n.getNodeToken1().accept(this);
    }

    @Override
    public void visit(VariableDeclarator n) {
        n.getNodeToken().accept(this);
        n.getNodeToken1().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
    }

    @Override
    public void visit(EmptyStatement n) {
        n.getNodeToken().accept(this);
    }

    @Override
    public void visit(IfStatement n) {
        n.getNodeToken().accept(this);
        n.getNodeToken1().accept(this);
        n.getExpression().accept(this);
        n.getNodeToken2().accept(this);
        n.getStatement().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
        if (n.getNodeOptional1().present()) {
            n.getNodeOptional1().accept(this);
        }
    }

    @Override
    public void visit(ForStatement n) {
        n.getNodeToken().accept(this);
        n.getNodeToken1().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
        n.getEmptyStatement().accept(this);
        n.getExpression().accept(this);
        n.getEmptyStatement1().accept(this);
        if (n.getNodeOptional1().present()) {
            n.getNodeOptional1().accept(this);
        }
        n.getNodeToken2().accept(this);
        n.getStatement().accept(this);
        if (n.getNodeOptional2().present()) {
            n.getNodeOptional2().accept(this);
        }
    }

    @Override
    public void visit(ForInit n) {
        n.getNodeChoice().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(ForEachStatement n) {
        n.getNodeToken().accept(this);
        n.getNodeToken1().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
        n.getNodeToken2().accept(this);
        n.getNodeToken3().accept(this);
        n.getExpression().accept(this);
        n.getNodeToken4().accept(this);
        n.getStatement().accept(this);
        if (n.getNodeOptional1().present()) {
            n.getNodeOptional1().accept(this);
        }
    }

    @Override
    public void visit(WhileStatement1 n) {
        n.getNodeToken().accept(this);
        n.getNodeToken1().accept(this);
        n.getExpression().accept(this);
        n.getNodeToken2().accept(this);
        n.getStatement().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
    }

    @Override
    public void visit(WhileStatement2 n) {
        n.getNodeToken().accept(this);
        n.getStatement().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
        n.getNodeToken1().accept(this);
        n.getNodeToken2().accept(this);
        n.getExpression().accept(this);
        n.getNodeToken3().accept(this);
        n.getEmptyStatement().accept(this);
    }

    @Override
    public void visit(SwitchStatement n) {
        n.getNodeToken().accept(this);
        n.getNodeToken1().accept(this);
        n.getExpression().accept(this);
        n.getNodeToken2().accept(this);
        n.getNodeToken3().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
        n.getNodeToken4().accept(this);
    }

    @Override
    public void visit(SwitchLabel n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(BreakStatement n) {
        n.getNodeToken().accept(this);
        n.getEmptyStatement().accept(this);
    }

    @Override
    public void visit(ReturnStatement n) {
        n.getNodeToken().accept(this);
        n.getExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(ContinueStatement n) {
        n.getNodeToken().accept(this);
        n.getEmptyStatement().accept(this);
    }

    @Override
    public void visit(ExitStatement n) {
        n.getNodeToken().accept(this);
        n.getEmptyStatement().accept(this);
    }

    @Override
    public void visit(StatementExpression n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(Assignment n) {
        n.getPrimaryExpression().accept(this);
        n.getAssignmentOperator().accept(this);
        n.getExpression().accept(this);
    }

    @Override
    public void visit(PreIncrementExpression n) {
        n.getNodeToken().accept(this);
        n.getPrimaryExpression().accept(this);
    }

    @Override
    public void visit(PreDecrementExpression n) {
        n.getNodeToken().accept(this);
        n.getPrimaryExpression().accept(this);
    }

    @Override
    public void visit(PrimaryExpression n) {
        n.getPrimaryPrefix().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(PrimaryPrefix n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(PrimaryVariable n) {
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
        n.getNodeToken().accept(this);
        if (n.getNodeOptional1().present()) {
            n.getNodeOptional1().accept(this);
        }
    }

    @Override
    public void visit(PrimarySuffix n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(Literal n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(IntegerLiteral n) {
        n.getNodeToken().accept(this);
    }

    @Override
    public void visit(FloatLiteral n) {
        n.getNodeToken().accept(this);
    }

    @Override
    public void visit(CharacterLiteral n) {
        n.getNodeToken().accept(this);
    }

    @Override
    public void visit(StringLiteral n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(BooleanLiteral n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(NullLiteral n) {
        n.getNodeToken().accept(this);
    }

    @Override
    public void visit(Arguments n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(ArgumentList n) {
        n.getNodeSequence().accept(this);
    }

    @Override
    public void visit(AssignmentOperator n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(PostfixExpression n) {
        n.getPrimaryExpression().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
    }

    @Override
    public void visit(Expression n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(ConditionalExpression n) {
        n.getConditionalOrExpression().accept(this);
        if (n.getNodeOptional().present()) {
            n.getNodeOptional().accept(this);
        }
    }

    @Override
    public void visit(ConditionalOrExpression n) {
        n.getConditionalAndExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(ConditionalAndExpression n) {
        n.getInclusiveOrExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(InclusiveOrExpression n) {
        n.getExclusiveOrExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(ExclusiveOrExpression n) {
        n.getAndExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(AndExpression n) {
        n.getEqualityExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(EqualityExpression n) {
        n.getRelationalExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(RelationalExpression n) {
        n.getShiftExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(ShiftExpression n) {
        n.getAdditiveExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(AdditiveExpression n) {
        n.getMultiplicativeExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(MultiplicativeExpression n) {
        n.getUnaryExpression().accept(this);
        if (n.getNodeListOptional().present()) {
            this.processList(n.getNodeListOptional());
        }
    }

    @Override
    public void visit(UnaryExpression n) {
        n.getNodeChoice().accept(this);
    }

    @Override
    public void visit(UnaryExpressionNotPlusMinus n) {
        n.getNodeChoice().accept(this);
    }
}

