/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import com.lowagie.text.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.ctrl.common.util.StreamUtil;
import kd.bos.print.core.ctrl.exception.ExportException;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.MainDataVisitor;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.exporter.R1PrintW2HTMLExporter;
import kd.bos.print.core.execute.helper.ExecuteHelper;
import kd.bos.print.core.execute.importer.R1PrintD2WImporter;
import kd.bos.print.core.model.designer.IR1Page;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.core.utils.HTMLUtils;
import kd.bos.print.core.utils.HtmlContext;
import kd.bos.print.core.utils.HtmlExportUtils;
import kd.bos.print.core.utils.PDFUtils;
import kd.bos.util.StringUtils;

public class HtmlPrintEngine {
    private static final int INITE_ARRAY_SIZE = 10;
    private static final Log log = LogFactory.getLog(HtmlPrintEngine.class);
    private boolean onlyOnePage = true;

    @Deprecated
    public void execute(List<RuntimeModel> runtimeModels, OutputStream outputStream) {
        String taskId = this.execute(runtimeModels);
        PrtAttach prtAttach = ExecuteService.getAttachService().getPrtAttach(taskId);
        PrtAttach.AttachDetail attachDetail = null;
        for (PrtAttach.AttachDetail prtDetail : prtAttach.getAttachDetail()) {
            if (!"C".equalsIgnoreCase(prtDetail.getSource())) continue;
            attachDetail = prtDetail;
            break;
        }
        if (attachDetail == null) {
            return;
        }
        String firstFilePath = attachDetail.getFilePath();
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(firstFilePath);
        try {
            StreamUtil.copy((InputStream)inputStream, (OutputStream)outputStream, (int)1024);
            StreamUtil.closeStream((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new PrintException("-1", e);
        }
    }

    public String execute(List<RuntimeModel> runtimeModels) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(10);
        for (RuntimeModel runtimeModel : runtimeModels) {
            ExecuteContext.get().setPluginProxy(runtimeModel.getPluginProxy());
            ExecuteContext.get().getServiceProxy().getDataService().setPluginProxy(runtimeModel.getPluginProxy());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.execute(runtimeModel, (OutputStream)out);
            list.add(out.toByteArray());
        }
        PrtAttach attach = new PrtAttach();
        attach.setTaskId(ExecuteContext.get().getTaskId());
        attach.setOrgId(ExecuteService.getUserService().getOrgId());
        attach.setAppId(ExecuteContext.get().getAppId());
        attach.setFormId(ExecuteContext.get().getFormId());
        attach.setUserId(ExecuteService.getUserId());
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        attachDetail.setFileName(runtimeModels.get(0).getPdfName() + ".pdf");
        attachDetail.setSource("C");
        attach.addAttachDetail(attachDetail);
        if (list.size() == 1) {
            String filePath = ExecuteService.getAttachService().savePrtFile(attachDetail.getFileName(), (byte[])list.get(0));
            attachDetail.setFilePath(filePath);
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PDFUtils.mergeMultiPdf(runtimeModels.get(0).getPdfName(), list, outputStream);
            String filePath = ExecuteService.getAttachService().savePrtFile(attachDetail.getFileName(), outputStream.toByteArray());
            attachDetail.setFilePath(filePath);
        }
        ExecuteService.getAttachService().savePrtResult(attach);
        return ExecuteContext.get().getTaskId();
    }

    private void execute(RuntimeModel runtimeModel, OutputStream outputStream) throws PrintException {
        R1PrintInfo pi = runtimeModel.getReportModel().getR1PrintInfo();
        Rectangle pageSize = HTMLUtils.getPageSize(pi);
        HtmlContext.get().setPageSize(pageSize);
        HtmlContext.get().setPrintInfo(pi);
        MainDataVisitor dataVisitor = (MainDataVisitor)runtimeModel.getDataVisitor(runtimeModel.getFormId());
        StringBuilder pageBuilder = new StringBuilder();
        while (dataVisitor.hasNext()) {
            HtmlContext.get().reset();
            List<PWPage> pwPages = this.importPage(runtimeModel);
            runtimeModel.beginInit();
            for (PWPage page : pwPages) {
                R1PrintW2HTMLExporter w2HTML = null;
                try {
                    w2HTML = new R1PrintW2HTMLExporter();
                }
                catch (ExportException e) {
                    throw new PrintException("-1", (Exception)((Object)e));
                }
                ExecuteHelper executeHelper = new ExecuteHelper(runtimeModel);
                String pageHtml = w2HTML.translate((IPrintWidget)page, (IWidgetExecuteHelper)executeHelper);
                if (!"".equals(pageBuilder.toString())) {
                    pageBuilder.append("<div style=\"page-break-after:always\"></div>");
                }
                pageBuilder.append(pageHtml);
                if (!this.onlyOnePage) continue;
                break;
            }
            dataVisitor.next();
        }
        String prtHtml = pageBuilder.toString();
        log.debug("2HTML" + prtHtml);
        List<String> srcList = HTMLUtils.getSrcList(prtHtml);
        prtHtml = prtHtml.replace("&", "");
        prtHtml = HTMLUtils.parseHtmlImgSrc(prtHtml, srcList);
        this.htmlToPdfStream(runtimeModel, prtHtml, outputStream);
    }

    private void htmlToPdfStream(RuntimeModel runtimeModel, String prtHtml, OutputStream outputStream) {
        StringBuilder sb = new StringBuilder();
        R1PrintInfo printInfo = HtmlContext.get().getPrintInfo();
        String pageStyle = HTMLUtils.getPageHtmlString(printInfo);
        sb.append("<html><head>").append(pageStyle).append("<title>");
        sb.append(runtimeModel.getPdfName()).append(".pdf");
        sb.append("</title>").append("</head><body style=\"font-family:SimSun,SimSun\">");
        sb.append(prtHtml);
        sb.append("</body></html>");
        try {
            String xhtml = sb.toString();
            Object destFile = null;
            try {
                if (this.getOutPutHtml(RequestContext.get().getTenantId())) {
                    FileUtil.saveString2File((String)(StringUtils.randomNumber((int)11) + ".html"), (String)sb.toString());
                }
                HtmlExportUtils.saveXhtml2PDF(runtimeModel, xhtml, outputStream);
            }
            catch (FileNotFoundException e1) {
                throw new RuntimeException(destFile + " FileNotFoundException error:" + e1.getMessage(), e1);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private boolean getOutPutHtml(String tenantId) {
        boolean isNeed = false;
        return isNeed;
    }

    private List<PWPage> importPage(RuntimeModel runtimeModel) throws PrintException {
        R1PrintD2WImporter d2w = null;
        try {
            d2w = new R1PrintD2WImporter(runtimeModel.getPluginProxy(), runtimeModel.getPkId());
        }
        catch (Exception e) {
            throw new PrintException("-1", e);
        }
        List designPages = runtimeModel.getReportModel().getPages();
        ArrayList<PWPage> pwPages = new ArrayList<PWPage>(10);
        for (IR1Page designPage : designPages) {
            IPrintWidget widget = d2w.translate((IReportObject)designPage);
            PWPage pwp = (PWPage)widget;
            pwp.setFooterHeight(designPage.getFooterHeight());
            pwPages.add(pwp);
        }
        return pwPages;
    }
}

