/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import com.lowagie.text.Rectangle;
import java.awt.Dimension;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.kdf.form2.ui.AbstractNotePrint;
import kd.bos.print.core.ctrl.print.IPrintActionListener;
import kd.bos.print.core.ctrl.print.IVariantParser;
import kd.bos.print.core.ctrl.print.config.PrintJobConfig;
import kd.bos.print.core.ctrl.print.config.attribute.FreeMediaSize;
import kd.bos.print.core.ctrl.print.config.attribute.MediaSizeNameExtend;
import kd.bos.print.core.ctrl.print.config.attribute.PageIntervalInfo;
import kd.bos.print.core.ctrl.print.printjob.BufferPrintJob;
import kd.bos.print.core.ctrl.print.printjob.IPrintJob;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import kd.bos.print.core.execute.R1PrintPageProvider;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.model.designer.ReportModel;
import kd.bos.print.core.utils.HTMLUtils;
import kd.bos.print.core.utils.HtmlContext;
import kd.bos.util.StringUtils;

public class PrintBrowser
extends AbstractNotePrint {
    private static final Log log = LogFactory.getLog(PrintBrowser.class);
    private boolean isCrossPrint = false;

    private R1PrintPageProvider createPageProvider(int forceStopPages) {
        R1PrintPageProvider pageProvider = new R1PrintPageProvider();
        pageProvider.setPagesOfForceStop(forceStopPages);
        pageProvider.setCrossPrint(this.isCrossPrint);
        return pageProvider;
    }

    private void generate(RuntimeModel runtimeModel, boolean sync, R1PrintPageProvider pageProvider) {
        final Generater generater = new Generater(pageProvider, runtimeModel);
        if (sync) {
            try {
                generater.generate();
            }
            catch (R1PrintDataException r1PrintDataException) {}
        } else {
            Thread thread = new Thread((Runnable)generater, "R1-Print Engine");
            this.getPrinterCtrl().addPreviewActionListener(new IPrintActionListener(){

                @Override
                public void beforePrintOrPreview() {
                }

                @Override
                public void beforePreview() {
                }

                @Override
                public void beforePrint() {
                }

                @Override
                public void closePreview() {
                    generater.stopPageProvider();
                }
            });
            thread.start();
        }
    }

    @Override
    public IPrintJob createPrintJob(Object templateModel) {
        RuntimeModel runtimeModel = (RuntimeModel)templateModel;
        R1PrintPageProvider pageProvider = this.createPageProvider(100000);
        this.generate(runtimeModel, true, pageProvider);
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = mo.getR1PrintInfo();
        return this.createPrintJob(mo, pi, pageProvider);
    }

    private IPrintJob createPrintJob(ReportModel model, R1PrintInfo pi, R1PrintPageProvider pageProvider) {
        BufferPrintJob prtJob = new BufferPrintJob();
        log.debug("\u521b\u5efa\u6253\u5370\u4efb\u52a1--");
        prtJob.setPageProvider(pageProvider);
        this.getPrinterCtrl().addPrintJob(prtJob);
        this.makePrintJobConfig(pi, prtJob.getConfig());
        prtJob.setDynamicPaper(pi.isDynamicPaper());
        prtJob.setVariantParser((IVariantParser)pageProvider.getDelayVarProvider());
        return prtJob;
    }

    private void makePrintJobConfig(R1PrintInfo pi, PrintJobConfig pjc) {
        pjc.getPrintRequestAttributeSet().add(PageIntervalInfo.getDefault());
        int leftMagin = pi.getMarginLeft();
        int rightMagin = pi.getMarginRight();
        int topMagin = pi.getMarginTop();
        int bottomMagin = pi.getMarginBottom();
        pjc.setLeftMargin(leftMagin < 0 ? 0 : leftMagin / 10, 1000);
        pjc.setRightMargin(rightMagin < 0 ? 0 : rightMagin / 10, 1000);
        pjc.setBodyTopMargin(topMagin < 0 ? 0 : topMagin / 10, 1000);
        pjc.setBodyBottomMargin(bottomMagin < 0 ? 0 : bottomMagin / 10, 1000);
        log.debug(String.format("\u5f53\u524d\u8fb9\u8ddd\u8d4b\u503c\u4e3a \u4e0a\uff1a%d  \u5de6\uff1a%d  \u5e95\uff1a%d  \u53f3\uff1a%d ", topMagin, leftMagin, bottomMagin, rightMagin));
        this.getPrinterCtrl().setDynamicPaper(pi.isDynamicPaper());
        this.getPrinterCtrl().setDynamicPaper(pi.isDynamicPaper());
        MediaSizeNameExtend media = null;
        if ("LANDSCAPE".equalsIgnoreCase(pi.getOrientation())) {
            pjc.addAttribute(OrientationRequested.LANDSCAPE);
        } else {
            pjc.addAttribute(OrientationRequested.PORTRAIT);
        }
        if (media == null) {
            int oriWidth = pi.getCustomWidth();
            int oriHeight = pi.getCustomHeight();
            float width = (float)oriWidth / 10.0f;
            float height = pi.isDynamicPaper() ? 65535.0f : (float)(oriHeight / 10);
            media = MediaSizeNameExtend.create();
            MediaSize ms = MediaSize.getMediaSizeForName(media);
            if (ms instanceof FreeMediaSize) {
                ((FreeMediaSize)ms).setXY(width, height, 1000);
            } else if (ms == null) {
                new FreeMediaSize(width, height, 1000, (MediaSizeName)media);
            }
        }
        pjc.addAttribute(media);
    }

    private MediaSizeName getMediaSizeName(String paperName) {
        String newName = "";
        switch (paperName) {
            case "B4": {
                newName = "iso-b4";
                break;
            }
            case "B5": {
                newName = "iso-b5";
                break;
            }
            case "A3": {
                newName = "iso-a3";
                break;
            }
            case "A4": {
                newName = "iso-a4";
                break;
            }
            case "A5": {
                newName = "iso-a5";
            }
        }
        if (StringUtils.isBlank((String)newName)) {
            return null;
        }
        return KDPrinterUtils.getMediaSizeName(newName);
    }

    @Override
    public void setCrossPrint(boolean isCrossPrint) {
        this.isCrossPrint = isCrossPrint;
    }

    private static class Generater
    implements Runnable {
        private R1PrintPageProvider pageProvider;
        private RuntimeModel runtimeModel;

        public Generater(R1PrintPageProvider pp, RuntimeModel mo) {
            this.pageProvider = pp;
            this.runtimeModel = mo;
        }

        @Override
        public void run() {
            try {
                this.generate();
            }
            catch (Throwable t) {
                this.pageProvider.errorForceStopped();
            }
        }

        public void generate() throws R1PrintDataException {
            ReportModel reportModel = this.runtimeModel.getReportModel();
            R1PrintInfo pi = reportModel.getR1PrintInfo();
            if (reportModel.hasRichText()) {
                Rectangle pageSize = HTMLUtils.getPageSize(pi);
                HtmlContext.get().setPageSize(pageSize);
                HtmlContext.get().setPrintInfo(pi);
            }
            Dimension dim = pi.getPrintableAreaSize();
            if (pi.isDynamicPaper()) {
                dim.height = 15000 - pi.getMarginTop() - pi.getMarginBottom();
            }
            this.pageProvider.generate(this.runtimeModel, dim.width, dim.height);
        }

        public void stopPageProvider() {
            this.pageProvider.forceStop();
        }
    }
}

