/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.exception.ExportException;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IR1PrintEngineListener;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.PageObject;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import kd.bos.print.core.data.MainDataVisitor;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.WidgetLayerHelpUtils;
import kd.bos.print.core.execute.exporter.R1PrintW2VExporter;
import kd.bos.print.core.execute.helper.ExecuteHelper;
import kd.bos.print.core.execute.importer.R1PrintD2WImporter;
import kd.bos.print.core.model.designer.IR1Page;
import kd.bos.print.core.model.designer.ReportModel;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.Page;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.runner.IRunner;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.model.widget.runner.util.RelativeContextUtils;
import kd.bos.print.core.model.widget.runner.util.SplicePrintUtils;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.utils.PTuple;
import kd.bos.service.InteTimeZone;
import kd.bos.util.StringUtils;

public class R1PrintEngine {
    private static final String BOS_PRINT_CORE = "bos-print-core";
    private static final Log log = LogFactory.getLog(R1PrintEngine.class);
    private RuntimeModel runtimeModel;
    private IR1PrintEngineListener listener;
    private ArrayList outputPages = new ArrayList();
    private ArrayList executedPages = new ArrayList();
    private IWidgetExecuteHelper executeHelper;
    private Map<String, List<String>> pageWidgetsMap = new HashMap<String, List<String>>(16);
    private PageObject pageObject = new PageObject();

    public R1PrintEngine(RuntimeModel runtimeModel, IR1PrintEngineListener listener) {
        this.runtimeModel = runtimeModel;
        this.listener = listener;
        this.executeHelper = new ExecuteHelper(runtimeModel);
    }

    public void setDelayVarProvider(DelayVarProvider dpv) {
        ((ExecuteHelper)this.executeHelper).setDelayVarProvider(dpv);
    }

    private RuntimeModel getRuntimeModel() {
        return this.runtimeModel;
    }

    private ReportModel getModel() {
        return this.runtimeModel.getReportModel();
    }

    public Page getOutputPage(int index) {
        if (this.outputPages != null) {
            Page page = (Page)this.outputPages.get(index);
            this.outputPages.set(index, null);
            return page;
        }
        return null;
    }

    private List<PWPage> importPage() throws R1PrintException {
        R1PrintD2WImporter d2w = null;
        try {
            d2w = new R1PrintD2WImporter(this.getRuntimeModel().getPluginProxy(), this.getRuntimeModel().getPkId());
        }
        catch (Exception e) {
            throw new R1PrintException((Throwable)e);
        }
        List designPages = this.getModel().getPages();
        this.pageWidgetsMap = WidgetLayerHelpUtils.initPageWidgetLayer((List)designPages);
        ArrayList<PWPage> pwPages = new ArrayList<PWPage>(10);
        for (IR1Page designPage : designPages) {
            IPrintWidget widget = d2w.translate((IReportObject)designPage);
            PWPage pwp = (PWPage)widget;
            pwp.setFooterHeight(designPage.getFooterHeight());
            pwPages.add(pwp);
        }
        return pwPages;
    }

    public void execute(int pageWidth, int pageHeight) throws R1PrintException {
        this.listener.beginOutput();
        RuntimeModel runtimeModel = this.getRuntimeModel();
        String formId = runtimeModel.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.executeOne(pageWidth, pageHeight);
        } else {
            MainDataVisitor dataVisitor = (MainDataVisitor)runtimeModel.getDataVisitor(formId);
            while (dataVisitor.hasNext()) {
                runtimeModel.beginInit();
                this.executeOne(pageWidth, pageHeight);
                dataVisitor.next();
            }
        }
        String pageNumType = this.pageObject.getPageNumType();
        if ("2".equals(pageNumType)) {
            this.executeHelper.getDelayVarProvider().fillValue("pageTotal", (Field)new IntegerField(Integer.valueOf(this.pageObject.getTotalPageNum())));
        }
    }

    private void executeOne(int pageWidth, int pageHeight) throws R1PrintException {
        this.pageObject.resetPage();
        List<PWPage> pwPages = this.importPage();
        RelativeContext relativeContext = null;
        int index = 0;
        PWPage lastCalPage = null;
        String pageNumType = this.pageObject.getPageNumType();
        PWPage emptyPage = null;
        boolean splicePrint = RelativeContextUtils.splicePrint(this.getRuntimeModel(), pwPages);
        for (PWPage page : pwPages) {
            page.getRectangle().setSize(pageWidth, pageHeight);
            emptyPage = (PWPage)page.copy();
            emptyPage.setChildren(new ArrayList());
            if (splicePrint) {
                PTuple<RelativeContext, PWPage> result = SplicePrintUtils.execute(page, relativeContext, this.pageObject, index, pwPages, lastCalPage);
                lastCalPage = (PWPage)result.item2;
                relativeContext = (RelativeContext)result.item1;
            } else {
                relativeContext = new RelativeContext(emptyPage, this.pageObject.getStartPage());
            }
            IRunner runner = page.getRunner();
            runner.setRelativeContext(relativeContext);
            runner.execute(this.executeHelper);
            Map pagePool = relativeContext.getPagePool();
            Map widgetPool = relativeContext.getWidgetPool();
            List lastPageWidgets = (List)widgetPool.get(PrintAtPage.Last.getCode());
            for (Map.Entry entry : pagePool.entrySet()) {
                PWPage pwPage = (PWPage)entry.getValue();
                if (this.executedPages.contains(pwPage)) continue;
                this.addWidgetToPage(pwPage, (List)widgetPool.get(PrintAtPage.All.getCode()));
                if (index != 0 && splicePrint && this.isEmptyPage(pwPage, pagePool, lastPageWidgets)) continue;
                this.pageObject.addPage();
                this.doDynamicPaper(pwPage);
                this.executedPages.add(pwPage);
            }
            if (!CollectionUtils.isEmpty((Collection)lastPageWidgets) && !CollectionUtils.isEmpty((Collection)this.executedPages)) {
                PWPage pwPage = (PWPage)this.executedPages.get(this.executedPages.size() - 1);
                this.addWidgetToPage(pwPage, lastPageWidgets);
                lastPageWidgets.clear();
            }
            relativeContext.finishDesignPage();
            ++index;
        }
        if (relativeContext != null) {
            relativeContext.release();
        }
        if (emptyPage != null && this.pageObject.isPageSeparation() && this.pageObject.getTotalPageNumForPageSeparation() % 2 != 0) {
            this.pageObject.addPageForPageSeparation();
            this.executedPages.add(emptyPage);
        }
        if (!"2".equals(pageNumType)) {
            this.executeHelper.getDelayVarProvider().fillValue("pageTotal", (Field)new IntegerField(Integer.valueOf(this.pageObject.getTotalPageNum())));
        }
        this.exportPage(true);
        this.listener.endOutput();
    }

    private boolean isEmptyPage(PWPage pwPage, Map<Integer, PWPage> pagePool, List<AbstractPrintWidget> lastPageWidgets) {
        return !(!PWidgetUtil.isEmptyPage((PWPage)pwPage) && !PWidgetUtil.isOnlyHeadFooterPage((PWPage)pwPage) || pwPage.getPageIndex() == pagePool.size() - 1 && !CollectionUtils.isEmpty(lastPageWidgets));
    }

    private void doDynamicPaper(PWPage pwPage) {
        int maxY2;
        if (!this.getModel().getR1PrintInfo().isDynamicPaper()) {
            return;
        }
        AbstractPrintWidget footerWidget = PWidgetUtil.findFooterPage((PWPage)pwPage);
        if (footerWidget == null) {
            return;
        }
        AbstractPrintWidget buttomWidget = PWidgetUtil.findButtomWidget((PWPage)pwPage);
        if (buttomWidget == null) {
            return;
        }
        Rectangle rectangle = footerWidget.getRectangle();
        rectangle.y = maxY2 = buttomWidget.getRectangle().y + buttomWidget.getRectangle().height;
    }

    private void addWidgetToPage(PWPage pwPage, List<AbstractPrintWidget> widgets) {
        if (widgets == null) {
            return;
        }
        for (AbstractPrintWidget widget : widgets) {
            this.addWidgetToPage(pwPage, widget);
        }
    }

    private void addWidgetToPage(PWPage pwPage, AbstractPrintWidget widget) {
        PWText pwText;
        String datasource;
        if (widget == null) {
            return;
        }
        widget.setPageIndex(pwPage.getPageIndex());
        if (widget instanceof PWFooter) {
            PWFooter pwFooter = (PWFooter)widget;
            List children = pwFooter.getChildren();
            if (children == null || children.isEmpty()) {
                pwPage.addChild((IPrintWidget)widget);
                return;
            }
            PWFooter copyFooter = (PWFooter)pwFooter.copy();
            ArrayList<AbstractPrintWidget> outPutChildren = new ArrayList<AbstractPrintWidget>(10);
            for (AbstractPrintWidget child : children) {
                child.setPageIndex(pwPage.getPageIndex());
                AbstractPrintWidget outPutWidget = this.fireAfterOutputWidget(child);
                outPutChildren.add(outPutWidget);
            }
            copyFooter.setChildren(outPutChildren);
            pwPage.addChild((IPrintWidget)copyFooter);
            return;
        }
        if (widget instanceof PWText && StringUtil.equals((String)(datasource = (pwText = (PWText)widget).getDatasource()), (String)"$DsKey=[System]")) {
            PWText copy = (PWText)pwText.copy();
            Object formulaResult = R1PrintEngine.runFormula(this.executeHelper, (IPrintWidget)copy, copy.getBindField());
            if (formulaResult != null) {
                copy.setOutputText(formulaResult.toString());
            }
            pwPage.addChild((IPrintWidget)copy);
            return;
        }
        pwPage.addChild((IPrintWidget)this.fireAfterOutputWidget(widget));
    }

    private AbstractPrintWidget fireAfterOutputWidget(AbstractPrintWidget widget) {
        PrintPluginProxy pluginProxy;
        PWText pwText;
        String datasource;
        boolean isCopy = false;
        AbstractPrintWidget outPutWidget = widget;
        if (outPutWidget instanceof PWText && StringUtil.equals((String)(datasource = (pwText = (PWText)outPutWidget).getDatasource()), (String)"$DsKey=[System]")) {
            PWText copy = (PWText)pwText.copy();
            if ("=now()".equals(pwText.getBindField()) && ("Date".equals(pwText.getTextFormat()) || "Time".equals(pwText.getTextFormat()))) {
                copy.setOutputText(pwText.getOutputText());
            } else {
                Object formulaResult = R1PrintEngine.runFormula(this.executeHelper, (IPrintWidget)copy, copy.getBindField());
                if (formulaResult != null) {
                    copy.setOutputText(formulaResult.toString());
                }
            }
            outPutWidget = copy;
            isCopy = true;
        }
        if ((pluginProxy = ExecuteContext.get().getPluginProxy()) == null) {
            return outPutWidget;
        }
        AfterOutputWidgetEvent evt = new AfterOutputWidgetEvent(outPutWidget);
        pluginProxy.fireAfterOutputWidget(evt);
        Field modifyValue = evt.getModifyValue();
        if (modifyValue == null) {
            return outPutWidget;
        }
        if (!isCopy) {
            outPutWidget = (AbstractPrintWidget)outPutWidget.copy();
        }
        this.setWidgetValue(outPutWidget, modifyValue);
        return outPutWidget;
    }

    private void setWidgetValue(AbstractPrintWidget widget, Field field) {
        if (widget instanceof AbstractPrintWidgetText && field instanceof TextField) {
            AbstractPrintWidgetText widgetText = (AbstractPrintWidgetText)widget;
            widgetText.setOutputText((String)((TextField)field).getValue());
            return;
        }
        widget.setOutputValue(field);
    }

    private void exportPage(boolean checkUnsure) throws R1PrintException {
        int index;
        int c = this.executedPages.size();
        for (index = 0; index < c; ++index) {
            PWPage page = (PWPage)this.executedPages.get(index);
            this.executeHelper.getDelayVarProvider().fillValue("pageNumber", (Field)new IntegerField(Integer.valueOf(page.getPageIndex() + 1)));
            if (checkUnsure && page.isUnsure()) break;
            R1PrintW2VExporter w2v = null;
            try {
                w2v = new R1PrintW2VExporter();
            }
            catch (ExportException e) {
                throw new R1PrintException((Throwable)e);
            }
            IPainter viewPage = w2v.translate((IPrintWidget)page);
            WidgetLayerHelpUtils.sortWidget(this.pageWidgetsMap, (IPainter)viewPage, (String)page.getId());
            this.outputPages.add(page.getPageIndex(), viewPage);
            this.listener.endPageOutput(page.getId(), page.getPageIndex());
        }
        for (int i = 0; i < index; ++i) {
            this.executedPages.remove(0);
        }
    }

    public static Object runFormula(IWidgetExecuteHelper helper, IPrintWidget widget, String target) {
        if (target != null && (target.startsWith("=") || target.startsWith("$"))) {
            Object result = helper.runFormula(widget, target.substring(1));
            if (result instanceof Date) {
                InteTimeZone sysTz = InteTimeZone.getSysTimeZone();
                return sysTz.format((Date)result);
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public void forceStop() {
    }

    @Deprecated
    public void setPagesOfForceStop(int n) {
    }

    public static void markOutputId(IWidgetExecuteHelper helper, List outputs) {
        int c = outputs.size();
        for (int i = 0; i < c; ++i) {
            Object obj = outputs.get(i);
            if (!(obj instanceof IPrintWidget)) continue;
            helper.markOutputId((IPrintWidget)obj);
        }
    }
}

