/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.kdf.form2.ui.INotePageProvider;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.control.PaperInfo;
import kd.bos.print.core.ctrl.print.printjob.IEconomizePrint;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;
import kd.bos.print.core.ctrl.print.util.SyncPageList;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IR1PrintEngineListener;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import kd.bos.print.core.execute.R1PrintEngine;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.LabelCell;
import kd.bos.print.core.model.ui.component.Page;

public class R1PrintPageProvider
implements INotePageProvider,
IEconomizePrint {
    private static Log log = LogFactory.getLog(R1PrintPageProvider.class);
    private SyncPageList _logicPageList;
    private R1PrintEngine _engine;
    private boolean _isVerEconomizePage;
    private boolean _isHorEconomizePage;
    private int _verDistance = 0;
    private int _horDistance = 0;
    private int _forceStopPages = 0;
    private boolean _isCrossPrint = false;
    private DelayVarProvider _delayVarProvider;
    private INotePageProvider.INotePageProviderListener _listener;

    private SyncPageList getLogicList() {
        if (this._logicPageList == null) {
            try {
                this._logicPageList = new SyncPageList(10);
            }
            catch (IOException ex) {
                throw new KDException((Throwable)ex, new ErrorCode("print-exception", "%s"), new Object[]{"where cause new page"});
            }
        }
        return this._logicPageList;
    }

    @Override
    public int getPageCount() {
        if (this._logicPageList != null) {
            return this._logicPageList.size();
        }
        return 0;
    }

    public void generate(RuntimeModel runtimeModel, int pageWidth, int pageHeight) {
        R1PrintInfo r1Info = runtimeModel.getReportModel().getR1PrintInfo();
        this._isVerEconomizePage = r1Info.isVerEconomizePaper();
        if (this._isVerEconomizePage) {
            this._verDistance = Util.lom2Pixel((int)r1Info.getVerPageSpace());
        }
        this._isHorEconomizePage = r1Info.isHorEconomizePaper();
        if (this._isHorEconomizePage) {
            this._horDistance = Util.lom2Pixel((int)r1Info.getHorPageSpace());
        }
        EngineListener engineListener = new EngineListener(pageHeight, pageWidth);
        this._engine = new R1PrintEngine(runtimeModel, engineListener);
        this._engine.setPagesOfForceStop(this._forceStopPages);
        this._engine.setDelayVarProvider(this.getDelayVarProvider());
        try {
            this._engine.execute(pageWidth, pageHeight);
        }
        catch (R1PrintException e) {
            String showMsg = "";
            String logMsg = "";
            StackTraceElement[] stackTrace = e.getStackTrace();
            Throwable cause = e.getCause();
            if (cause != null) {
                stackTrace = cause.getStackTrace();
                showMsg = e instanceof R1PrintDataException ? String.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff0c\u67e5\u8be2\u6570\u636e\u5f02\u5e38\uff1a%s\u3002", (String)"R1PrintPageProvider_0", (String)"bos-print-core", (Object[])new Object[0]), cause.getMessage()) : String.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u8be2\u65e5\u5fd7\uff1a%s\u3002", (String)"R1PrintPageProvider_1", (String)"bos-print-core", (Object[])new Object[0]), cause.getMessage());
            } else {
                cause = e;
                showMsg = String.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u8be2\u65e5\u5fd7\uff1a%s\u3002", (String)"R1PrintPageProvider_1", (String)"bos-print-core", (Object[])new Object[0]), cause.getMessage());
            }
            logMsg = Arrays.stream(stackTrace).map(trace -> trace.toString()).collect(Collectors.joining(" \n"));
            if (ExecuteService.isShowExp()) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{showMsg + "\n" + logMsg});
            }
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{showMsg});
        }
        catch (Exception e) {
            throw e;
        }
        this._engine = null;
    }

    public void errorForceStopped() {
        this.finish();
    }

    @Override
    public void forceStop() {
        if (this._engine != null) {
            this._engine.forceStop();
        }
    }

    public void setPagesOfForceStop(int n) {
        this._forceStopPages = n;
    }

    public void setCrossPrint(boolean isCrossPrint) {
        this._isCrossPrint = isCrossPrint;
    }

    private void addExceptionPromptPage(int pageWidth, int pageHeight, String prompt) {
        int w = Util.lom2Pixel((int)pageWidth);
        int h = Util.lom2Pixel((int)pageHeight);
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
        sa.setWrapText(true);
        Style style = Styles.getStyle((ShareStyleAttributes)sa);
        LabelCell labelCell = new LabelCell();
        labelCell.setText("\r\n" + new Date() + "\r\n" + prompt);
        labelCell.setStyle(style);
        labelCell.setPainterBounds(0.0f, 0.0f, (float)w, (float)h);
        Page page = new Page();
        page.setPainterBounds(0.0f, 0.0f, (float)w, (float)h);
        page.addPainter((IPainter)labelCell);
        this.addPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page get(int index, PaperInfo info) {
        SyncPageList pageList = this.getLogicList();
        log.debug("Request get page, index: " + index);
        SyncPageList syncPageList = pageList;
        synchronized (syncPageList) {
            if (index >= pageList.getPageCount() && pageList.isCompleted()) {
                log.debug("No more pages, return null.");
                return null;
            }
            return pageList.getPage(index);
        }
    }

    public DelayVarProvider getDelayVarProvider() {
        if (this._delayVarProvider == null) {
            this._delayVarProvider = new DelayVarProvider();
        }
        return this._delayVarProvider;
    }

    @Override
    public void setListener(INotePageProvider.INotePageProviderListener l) {
        this._listener = l;
    }

    private void addPage(Page page) {
        this.getLogicList().addPage(page);
        if (this._listener != null && this.getLogicList().size() == 1) {
            this._listener.firstPagePrepared();
        }
    }

    private void finish() {
        this.getLogicList().close();
        if (this._listener != null && this.getLogicList().size() == 0) {
            this._listener.cancelBeforeOutput();
        }
    }

    @Override
    public int getHorSpace() {
        return this._horDistance;
    }

    @Override
    public int getVerSpace() {
        return this._verDistance;
    }

    @Override
    public boolean isEconomizePaper() {
        return this._isCrossPrint && (this._isVerEconomizePage || this._isHorEconomizePage);
    }

    @Override
    public boolean isHorEconomizePaper() {
        return this._isHorEconomizePage;
    }

    @Override
    public boolean isVerEconomizePaper() {
        return this._isVerEconomizePage;
    }

    public void clearTempFile() {
        this.getLogicList().destroy();
    }

    private class EngineListener
    implements IR1PrintEngineListener {
        private float bodyHeight;
        private float bodyWidth;
        private List<Page> tempPages = new ArrayList<Page>();
        private float remainHeight;
        private float remainWidth;

        public EngineListener(int bodyHeight, int bodyWidth) {
            this.bodyHeight = (float)KDPrinterUtils.lomToPrintPoint(bodyHeight);
            this.bodyWidth = (float)KDPrinterUtils.lomToPrintPoint(bodyWidth);
        }

        private List<Page> getTempPages() {
            return this.tempPages;
        }

        public void beginOutput() {
            log.debug("Begin R1Print Engine.");
        }

        public void beginPageOutput(String id, int idx) {
            log.debug("Begin page output, id:" + id + " , index: " + idx);
        }

        public void endPageOutput(String id, int idx) {
            Page pg = R1PrintPageProvider.this._engine.getOutputPage(idx);
            if (!R1PrintPageProvider.this._isCrossPrint && (R1PrintPageProvider.this._isVerEconomizePage || R1PrintPageProvider.this._isHorEconomizePage)) {
                int index;
                this.cutPageBlankTail(pg);
                this.getTempPages().add(pg);
                log.debug("\u8282\u7eb8\u6253\u5370\uff0c\u5c1d\u8bd5\u62fc\u7eb8\u5f20\u5927\u91cc\u5c0f\u7684\u9875\u3002\u4e34\u65f6\u5217\u8868\u9875\u6570\uff1a" + this.getTempPages().size());
                this.remainHeight = this.bodyHeight;
                this.remainWidth = this.bodyWidth;
                boolean isOutput = false;
                float maxHeight = 0.0f;
                int c = this.getTempPages().size();
                for (index = 0; index < c; ++index) {
                    Page page = this.getTempPages().get(index);
                    maxHeight = Math.max(maxHeight, page.getHeight());
                    if (index == 0) {
                        this.remainWidth -= page.getWidth() + (float)R1PrintPageProvider.this._horDistance;
                        this.remainHeight -= page.getHeight() + (float)R1PrintPageProvider.this._verDistance;
                    }
                    this.remainWidth = R1PrintPageProvider.this._isHorEconomizePage ? (this.remainWidth -= page.getWidth()) : -1.0f;
                    if (this.remainWidth < 0.0f) {
                        if (R1PrintPageProvider.this._isVerEconomizePage) {
                            this.remainHeight -= maxHeight;
                            if (this.remainHeight < 0.0f) {
                                isOutput = true;
                                break;
                            }
                            maxHeight = 0.0f;
                            this.remainHeight -= (float)R1PrintPageProvider.this._verDistance;
                            this.remainWidth = this.bodyWidth - page.getWidth();
                        } else {
                            isOutput = true;
                            break;
                        }
                    }
                    this.remainWidth -= (float)R1PrintPageProvider.this._horDistance;
                }
                if (isOutput) {
                    log.debug("\u8282\u7eb8\u6253\u5370\uff0c\u62fc\u7eb8\u5f20\u5927\u5c0f\u7684\u9875\u6210\u529f\u3002");
                    R1PrintPageProvider.this.addPage(this.togetherPage(++index));
                }
            } else {
                R1PrintPageProvider.this.addPage(pg);
            }
            log.debug("End page " + idx + " output.");
        }

        public void endOutput() {
            if ((R1PrintPageProvider.this._isVerEconomizePage || R1PrintPageProvider.this._isHorEconomizePage) && this.getTempPages().size() > 0) {
                log.debug("R1Print\u6267\u884c\u7ed3\u675f\uff0c\u8282\u7eb8\u6253\u5370\uff0c\u6240\u6709\u5269\u4f59\u7684\u9875\u62fc\u6210\u7eb8\u5f20\u5927\u5c0f\u7684\u9875\u8f93\u51fa\u3002");
                R1PrintPageProvider.this.addPage(this.togetherPage(this.getTempPages().size()));
            }
            log.debug("End R1Print Engine.");
            R1PrintPageProvider.this.finish();
        }

        private void cutPageBlankTail(Page page) {
            float maxBottom = 0.0f;
            float maxRight = 0.0f;
            for (IPainter child : page.getAllPainter()) {
                float bottom = child.getY() + child.getHeight();
                float right = child.getX() + child.getWidth();
                if (maxBottom < bottom) {
                    maxBottom = bottom;
                }
                if (!(maxRight < right)) continue;
                maxRight = right;
            }
            if (maxBottom < page.getHeight()) {
                page.setHeight(maxBottom);
            }
            if (maxRight < page.getWidth()) {
                page.setWidth(maxRight);
            }
        }

        private Page togetherPage(int pageCounts) {
            Page page1 = this.getTempPages().remove(0);
            Page pageNow = new Page();
            pageNow.setHeight(page1.getHeight());
            pageNow.setWidth(page1.getWidth());
            float addedX = page1.getWidth() + (float)R1PrintPageProvider.this._horDistance;
            float addedY = page1.getY();
            float maxHeight = page1.getHeight();
            page1.setWidth(this.bodyWidth);
            page1.setHeight(this.bodyHeight);
            for (int i = 1; i < pageCounts; ++i) {
                Page pageN = this.getTempPages().remove(0);
                maxHeight = Math.max(maxHeight, pageNow.getHeight());
                page1.addPainter((IPainter)pageN);
                if (R1PrintPageProvider.this._isHorEconomizePage && addedX + pageN.getWidth() < this.bodyWidth) {
                    pageN.setX(addedX);
                }
                if (R1PrintPageProvider.this._isVerEconomizePage && (!R1PrintPageProvider.this._isHorEconomizePage || addedX + pageNow.getWidth() > this.bodyWidth)) {
                    addedX = page1.getX();
                    addedY += maxHeight + (float)R1PrintPageProvider.this._verDistance;
                    maxHeight = 0.0f;
                }
                pageN.setY(addedY);
                addedX += pageNow.getWidth() + (float)R1PrintPageProvider.this._horDistance;
                pageNow = pageN;
            }
            return page1;
        }
    }
}

