/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter;

import java.awt.Color;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.execute.exporter.R1PrintW2HTMLExporter;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.utils.HTMLUtils;
import kd.bos.print.core.utils.HtmlContext;
import kd.bos.print.core.utils.MapUtils;
import kd.bos.util.StringUtils;

public abstract class AR1PNode2HTML {
    private IPrintWidget _node;
    private R1PrintW2HTMLExporter _exporter;
    private Map<String, String> styleMap = new HashMap<String, String>();
    private List<String> contentList = new ArrayList<String>();
    private IWidgetExecuteHelper executeHelper;
    private boolean isChild = false;
    private boolean isRelative = false;
    private boolean isOverFlow = false;
    private boolean needCalculateRelative;
    private boolean needSetMaxY;
    private String styleString;
    private boolean needWidth = true;
    private boolean needHeight = true;

    public String getStyleString() {
        return this.styleString;
    }

    public void setStyleString(String styleString) {
        this.styleString = styleString;
    }

    public boolean isChild() {
        return this.isChild;
    }

    public void setChild(boolean isChild) {
        this.isChild = isChild;
    }

    public boolean isOverFlow() {
        return this.isOverFlow;
    }

    public void setOverFlow(boolean isOverFlow) {
        this.isOverFlow = isOverFlow;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    public boolean isNeedRelative() {
        return this.isRelative || this.isChild;
    }

    public void setRelative(boolean isRelative) {
        this.isRelative = isRelative;
    }

    public void setExporter(R1PrintW2HTMLExporter exporter) {
        this._exporter = exporter;
        this.executeHelper = exporter.getExecuteHelper();
    }

    protected R1PrintW2HTMLExporter getExporter() {
        return this._exporter;
    }

    public void setNode(IPrintWidget node) {
        this._node = node;
    }

    protected IPrintWidget getNode() {
        return this._node;
    }

    public String exporting() {
        Style wStyle = StyleAccess.getStyle((IPrintWidget)this.getNode());
        if (wStyle.getBackground() != null) {
            this.styleMap.put("background-color", StyleAccess.color2string((Color)wStyle.getBackground()));
        }
        double oriHeigh = this.getNode().getRectangle().getHeight();
        this.exportSpecial(this.getNode());
        this.exportCommon(this.getNode());
        double oldMaxHeight = HtmlContext.get().getMaxHeight();
        double oldMayxY = HtmlContext.get().getMaxY();
        this.calculateMaxHeight(this.getNode().getRectangle());
        if (this.isNeedCalculateRelative()) {
            HTMLUtils.setContextCurrentYValue(this.getNode().getRectangle(), oldMaxHeight, oldMayxY);
            HTMLUtils.setContextCurrentHeigh(this.getNode().getRectangle());
            HTMLUtils.setOrginalHeight(oriHeigh);
        }
        if (this.isNeedSetMaxY()) {
            HtmlContext.get().setMaxY(this.getNode().getRectangle().y);
        }
        return this.toHtml();
    }

    protected void exportChildren(IPrintWidget widget) {
    }

    protected void addContent(String content) {
        this.contentList.add(content);
    }

    protected void resetContent() {
        this.styleMap = new HashMap<String, String>();
        this.contentList = new ArrayList<String>();
    }

    private String toHtml() {
        StringBuilder content = new StringBuilder();
        content.append(this.getStartWithStyle());
        content.append(this.getContent());
        content.append(this.getEnd());
        return content.toString();
    }

    private String getStartWithStyle() {
        StringBuilder content = new StringBuilder();
        content.append("<div ");
        if (this.styleMap.size() > 0) {
            content.append("style=\"");
            for (String key : this.styleMap.keySet()) {
                content.append(" ");
                content.append(this.diplayKey(key));
                content.append(this.styleMap.get(key));
                content.append(";");
            }
            if (StringUtils.isNotEmpty((String)this.styleString)) {
                content.append(this.styleString);
            }
            content.append("\"");
        }
        content.append(">");
        return content.toString();
    }

    private String diplayKey(String key) {
        return key + ":";
    }

    private String getContent() {
        StringBuilder content = new StringBuilder();
        if (this.contentList != null) {
            for (int i = 0; i < this.contentList.size(); ++i) {
                content.append(this.contentList.get(i));
            }
        }
        return content.toString();
    }

    private Object getEnd() {
        return "</div>";
    }

    private void exportCommon(IPrintWidget widget) {
        Rectangle rect = widget.getRectangle();
        Map<String, String> rStyleMap = null;
        if (rect != null) {
            HtmlContext context = HtmlContext.get();
            if (!(widget instanceof PWPage)) {
                this.setRelative(HtmlContext.get().isRelativePosition());
            }
            boolean isRoot = false;
            if (widget instanceof PWPage) {
                isRoot = true;
            }
            rStyleMap = HTMLUtils.convertRectange(rect, this.isRelative(), this.isOverFlow(), isRoot);
            if (!this.isNeedWidth()) {
                rStyleMap.remove("width");
            }
            if (!this.isNeedHeight()) {
                rStyleMap.remove("height");
            }
            if (!this.isOverFlow() && widget instanceof PWText || this.isNeedRelative()) {
                context.setRelativePosition(true);
            }
        }
        Map<String, String> styleAccessMap = HTMLUtils.convertStypleAcess(StyleAccess.getStyle((IPrintWidget)widget));
        Map<String, String> twoMap = MapUtils.combineMap2One(rStyleMap, styleAccessMap);
        this.styleMap = MapUtils.combineMap2One(this.styleMap, twoMap);
    }

    private void calculateMaxHeight(Rectangle rect) {
        HtmlContext context = HtmlContext.get();
        if (context.getMaxHeight() == 0.0) {
            context.setMaxHeight((double)rect.y + rect.getHeight());
        } else if ((double)rect.y + rect.getHeight() > context.getMaxHeight() && !this.isRelative()) {
            context.setMaxHeight((double)rect.y + rect.getHeight());
        } else if (this.isRelative() && (double)rect.y > context.getFirstY() && (double)rect.y - context.getFirstY() + rect.getHeight() + context.getCurrentHeight() + context.getCurrentYValue() > context.getMaxHeight()) {
            context.setMaxHeight((double)rect.y - context.getFirstY() + rect.getHeight() + context.getCurrentHeight() + context.getCurrentYValue());
            this.setNeedSetMaxY(true);
        }
    }

    protected Field formatOutputValue(Field outputValue) {
        if (outputValue == null) {
            return NullField.get();
        }
        Object value = outputValue.getValue();
        if (outputValue instanceof NullField || value == null || StringUtils.isBlank((String)value.toString())) {
            return NullField.get();
        }
        return outputValue;
    }

    protected String formatNumber(BigDecimal value, NumberFormatObject numberformatObj, boolean ignoreTailZero, int scale) {
        FormatObject formatObject = new FormatObject();
        if (ignoreTailZero) {
            value = value.stripTrailingZeros();
        }
        if (scale == -1) {
            scale = value.scale();
        }
        numberformatObj.setMinimumFractionDigits(scale);
        formatObject.setNumberFormat(numberformatObj);
        String num = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(formatObject).format(value);
        return num;
    }

    protected BigDecimal toBigDecimal(Object value) {
        BigDecimal ret = BigDecimal.ZERO;
        if (value instanceof BigDecimal) {
            ret = (BigDecimal)value;
        } else if (value instanceof String) {
            try {
                ret = new BigDecimal((String)value);
            }
            catch (Exception exception) {}
        } else if (value instanceof BigInteger) {
            ret = new BigDecimal((BigInteger)value);
        } else if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return ret;
    }

    protected IWidgetExecuteHelper.IDataHelper getDataHelper(IPrintWidget widget, IWidgetExecuteHelper helper, String ds) {
        IWidgetExecuteHelper.IDataHelper dataHelper = helper.getDataHelper();
        return dataHelper;
    }

    protected abstract String exportSpecial(IPrintWidget var1);

    public boolean isNeedCalculateRelative() {
        return this.needCalculateRelative;
    }

    public void setNeedCalculateRelative(boolean needCalculateRelative) {
        this.needCalculateRelative = needCalculateRelative;
    }

    public boolean isNeedSetMaxY() {
        return this.needSetMaxY;
    }

    public void setNeedSetMaxY(boolean needSetMaxY) {
        this.needSetMaxY = needSetMaxY;
    }

    public boolean isNeedWidth() {
        return this.needWidth;
    }

    public void setNeedWidth(boolean needWidth) {
        this.needWidth = needWidth;
    }

    public boolean isNeedHeight() {
        return this.needHeight;
    }

    public void setNeedHeight(boolean needHeight) {
        this.needHeight = needHeight;
    }
}

