/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.exporter.AR1PNode2HTML;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.ui.component.BarCodeCell;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.barcode.BarcodeUtils;
import kd.bos.print.core.model.widget.barcode.PWBarcode;

public class R1PBarcode2HTML
extends AR1PNode2HTML {
    private static final Log log = LogFactory.getLog(R1PBarcode2HTML.class);
    private static final String AUTO_MATCH = "autoMatch";

    protected IPainter createViewt(IPrintWidget node) {
        return new BarCodeCell();
    }

    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        PWBarcode pwBarcode = (PWBarcode)widget;
        BarCodeCell barcodeCell = (BarCodeCell)view;
        Field outputValue = pwBarcode.getOutputValue();
        if (outputValue != null && StringUtils.isNotBlank((Object)outputValue.getValue())) {
            barcodeCell.setConfig((Map)outputValue.getValue());
        }
    }

    public static Image loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = R1PBarcode2HTML.blobToBytes((Blob)value);
            } else if (value instanceof String && value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
                imageData = ImageUtil.getImageByUrl((String)((String)value));
            }
            if (imageData != null) {
                return ImageUtil.makeImage((byte[])imageData);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] blobToBytes(Blob blob) {
        ByteArrayOutputStream baos = null;
        try (InputStream is = blob.getBinaryStream();){
            if (is != null) {
                baos = new ByteArrayOutputStream();
                byte[] c = new byte[1024];
                int len = 0;
                while ((len = is.read(c, 0, c.length)) != -1) {
                    baos.write(c, 0, len);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new byte[0];
    }

    @Override
    protected String exportSpecial(IPrintWidget widget) {
        PWBarcode pwBarcode = (PWBarcode)widget;
        BarcodeObject barcodeObject = pwBarcode.getBarcodeObject();
        Field outputValue = null;
        Field opValue = pwBarcode.getOutputValue();
        String ds = pwBarcode.getDatasource();
        if (opValue != null) {
            outputValue = opValue;
        } else if (StringUtils.isNotBlank((CharSequence)ds)) {
            if (StringUtils.isNotBlank((CharSequence)barcodeObject.getBindField())) {
                String fieldName = barcodeObject.getBindField();
                outputValue = this.getDataHelper((IPrintWidget)pwBarcode, this.getExporter().getExecuteHelper(), ds).getFieldValue(ds, fieldName);
            }
        } else {
            outputValue = StringUtils.isNotEmpty((CharSequence)pwBarcode.getBarcodeObject().getBindField()) ? new TextField(pwBarcode.getBarcodeObject().getBindField()) : new TextField(barcodeObject.getSampleTxt());
        }
        if (outputValue != null && StringUtils.isNotBlank((Object)outputValue.getValue())) {
            boolean isQr;
            String code = outputValue.getValue().toString();
            String prefix = barcodeObject.getPrefix();
            String suffix = barcodeObject.getSuffix();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                code = prefix + code;
            }
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                code = code + suffix;
            }
            boolean bl = isQr = "QR_CODE".equalsIgnoreCase(barcodeObject.getBarcodeType()) || "DATA_MATRIX".equalsIgnoreCase(barcodeObject.getBarcodeType()) || "PDF_417".equalsIgnoreCase(barcodeObject.getBarcodeType());
            if (isQr && this.containsNonAsciiChar(code)) {
                code = code + "\n";
            }
            Map<String, Object> config = this.generateConfig(barcodeObject, code);
            outputValue = new MapField(config);
            config.put("hasLineStyle", false);
            int width = (int)pwBarcode.getRectangle().getWidth();
            int height = (int)pwBarcode.getRectangle().getHeight();
            Integer rotate = (Integer)config.get("rotate");
            if (rotate != null && (rotate == 90 || rotate == 270)) {
                height = (int)pwBarcode.getRectangle().getWidth();
                width = (int)pwBarcode.getRectangle().getHeight();
            }
            boolean isQR = this.isQR(config);
            BufferedImage image = null;
            int last = width > height ? height : width;
            image = isQR ? new BufferedImage(last, last, 1) : new BufferedImage(width, height, 1);
            Graphics g = image.getGraphics();
            try {
                BufferedImage image2;
                if (isQR) {
                    Rectangle rect = pwBarcode.getRectangle();
                    BarcodeUtils.paintBarcode((Graphics)g, (int)last, (int)last, config);
                    int gap = (int)((rect.getWidth() - rect.getHeight()) / 2.0);
                    pwBarcode.getRectangle().setRect(rect.x + gap, rect.y, last, last);
                } else {
                    BarcodeUtils.paintBarcode((Graphics)g, (int)width, (int)height, config);
                }
                if (rotate != null && (rotate == 90 || rotate == 270)) {
                    image = image2 = ImageUtil.rotateImage((Image)image, (int)rotate);
                } else if (rotate != null && rotate != 0) {
                    image = image2 = ImageUtil.rotateImage((Image)image, (int)rotate);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", out);
                this.addContent(ImageUtil.getHtmlImageDisplayStringByBuytes((byte[])out.toByteArray()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "barcode";
    }

    private boolean isQR(Map config) {
        String type;
        boolean isQR = false;
        if (config != null && "QR_CODE".equals(type = (String)config.get("barcodeType"))) {
            isQR = true;
        }
        return isQR;
    }

    public static void saveBytesToFile(byte[] buffer, String fileName) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);){
            fileOutputStream.write(buffer);
            fileOutputStream.close();
        }
    }

    private boolean containsNonAsciiChar(String code) {
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c <= '\u0080') continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> generateConfig(BarcodeObject barcodeObject, String code) {
        double last;
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("barcode", code);
        double height = (double)barcodeObject.getHeight() * 0.1;
        double width = (double)barcodeObject.getWidth() * 0.1;
        double d = last = width > height ? height : width;
        if (this.isQR(config)) {
            config.put("height", last);
            config.put("width", last);
        } else {
            config.put("height", height);
            config.put("width", width);
        }
        config.put("dpi", barcodeObject.getDpi());
        config.put("modelWidth", barcodeObject.getModelWidth());
        config.put("shape", barcodeObject.getShape());
        if (barcodeObject.getScale() == 3) {
            config.put(AUTO_MATCH, true);
        } else {
            config.put(AUTO_MATCH, false);
        }
        config.put("barcodeType", barcodeObject.getBarcodeType());
        config.put("showText", barcodeObject.isShowText());
        config.put("errorCorrectionLevel", barcodeObject.getErrorCorrection());
        config.put("rotate", barcodeObject.getRotate());
        return config;
    }
}

