/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.execute.ExecuteContext;
import kd.bos.print.core.execute.exporter.AR1PNode2HTML;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.stat.GridStatSet;
import kd.bos.print.core.utils.HTMLUtils;
import kd.bos.print.core.utils.HtmlContext;
import kd.bos.session.SystemPropertyUtils;

public class R1PDataGrid2HTML
extends AR1PNode2HTML {
    protected GridStatSet statSet;
    protected IWidgetExecuteHelper helper;
    private static Log logger = LogFactory.getLog(R1PDataGrid2HTML.class);

    protected IPainter createViewt(IPrintWidget node) {
        return new Canvas();
    }

    protected void executeTitleRow(PWDataGrid outputGrid, AbstractPWGridRow row, boolean isStatic) {
        this.executeRow(outputGrid, row, isStatic, (ds, field) -> {
            Field fieldValue = this.getExporter().getExecuteHelper().getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        });
    }

    protected void executeRow(PWDataGrid outputGrid, AbstractPWGridRow row, boolean isStatic, GridDataVisitor visitor) {
        StringBuilder tr = new StringBuilder();
        tr.append("<tr style=\"").append("height:").append(HTMLUtils.getHtmlConvertValue(row.getHeight())).append(";\">");
        int columnCursor = 0;
        int columnCount = outputGrid.getColumnCount();
        if (this.isChild()) {
            outputGrid.getRectangle().setRect(outputGrid.getRectangle().x, outputGrid.getRectangle().y, (int)outputGrid.getRectangle().getWidth(), outputGrid.getRectangle().getHeight() + (double)row.getHeight());
        } else {
            outputGrid.getRectangle().setRect(outputGrid.getRectangle().x, outputGrid.getRectangle().y, (int)outputGrid.getRectangle().getWidth(), row.getHeight());
        }
        this.setChild(true);
        while (columnCursor < columnCount) {
            TextRunner runner;
            Field outputValue;
            CellValueStat field;
            AbstractPWGridColumn column = outputGrid.getColumn(columnCursor);
            int columnWidth = column.getWidth();
            AbstractPWGridCell cell = row.getCell(columnCursor);
            AbstractPWGridCell outputCell = (AbstractPWGridCell)cell.copy();
            int width = column.getWidth();
            String mergeString = "";
            if (isStatic) {
                mergeString = HTMLUtils.getCellMergeString((AbstractPWGrid)outputGrid, 2, columnCursor);
                if ("NEED_INGORE".equals(mergeString)) {
                    ++columnCursor;
                    continue;
                }
                width = HTMLUtils.getWidthOfColumn((AbstractPWGrid)outputGrid, 2, columnCursor);
            }
            String widthString = "width:" + HTMLUtils.getHtmlConvertValue(width) + ";";
            Style wStyle = StyleAccess.getStyle((IPrintWidget)cell);
            String borderString = HTMLUtils.getBoderTextByStyle(wStyle);
            String color = HTMLUtils.getBackground(wStyle);
            String styleString = " style=" + HTMLUtils.addDoubleQuotationMark(color + widthString + borderString);
            String alignString = HTMLUtils.getAlignStyle(wStyle);
            alignString = !"0".equals(alignString) ? " align=" + HTMLUtils.addDoubleQuotationMark(alignString) : "";
            tr.append("<td").append(styleString).append(alignString).append(mergeString).append(" >");
            ACellValue cellValue = outputCell.getCellValue();
            String outputText = "";
            String dataSource = outputCell.getDatasource();
            if (StringUtils.isBlank((CharSequence)dataSource)) {
                if (cellValue instanceof CellValueText) {
                    outputText = ((CellValueText)cellValue).getValue();
                    outputText = HTMLUtils.getTextByStyle(wStyle, outputText);
                }
            } else if (cellValue instanceof CellValueStat) {
                field = (CellValueStat)cellValue;
                outputValue = visitor.getFormatVal(dataSource, (CellValueField)field);
                runner = (TextRunner)outputCell.getRunner();
                outputValue = runner.formatOutputValue(outputValue);
                outputText = outputValue.toString();
                outputText = HTMLUtils.getTextByStyle(wStyle, outputText);
            } else if (cellValue instanceof CellValueField) {
                field = (CellValueField)cellValue;
                outputValue = visitor.getFormatVal(dataSource, (CellValueField)field);
                runner = (TextRunner)outputCell.getRunner();
                outputValue = runner.formatOutputValue(outputValue);
                outputText = outputValue.toString();
                outputText = HTMLUtils.getTextByStyle(wStyle, outputText);
            }
            tr.append(outputText);
            tr.append("</td>");
            ++columnCursor;
        }
        tr.append("</tr>");
        this.addContent(tr.toString());
    }

    protected void executeDetailRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, boolean isStatic, PdIterator iterator) {
        String gridds = outputGrid.getDatasource();
        this.executeRow(outputGrid, (AbstractPWGridRow)row, isStatic, (ds, field) -> {
            if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds)) {
                Field fieldValue = iterator.getField(field.getField());
                return fieldValue;
            }
            Field fieldValue = this.getExporter().getExecuteHelper().getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        });
    }

    protected R1PDataVisitor getDataVisitor(PWDataGrid outputGrid) {
        String datasource = outputGrid.getDatasource();
        if (StringUtils.isBlank((CharSequence)datasource)) {
            return null;
        }
        IWidgetExecuteHelper.IDataHelper dataHelper = this.getExporter().getExecuteHelper().getDataHelper();
        R1PDataVisitor dataVisitor = dataHelper.getDataVisitor(datasource);
        return dataVisitor;
    }

    private static void dealStyle(PWDataGrid dataGrid, AbstractPWDataGridRow currentRow, PWDataGridColumn currentCol, PWDataGridCell currentCell, int rowIdx, int colIdx) {
        boolean isLastAtRow = true;
        int c = dataGrid.getOutputColumns().size();
        for (int j = colIdx + 1; j < c; ++j) {
            if (currentRow.getCell(j) == null || !((PWDataGridColumn)dataGrid.getOutputColumn(j)).isPrintable()) continue;
            isLastAtRow = false;
            break;
        }
        int rowBorderTag = colIdx == 0 ? (isLastAtRow ? 4369 : 4881) : (isLastAtRow ? 12561 : 13073);
        boolean isLastAtCol = true;
        int c2 = dataGrid.getOutputRows().size();
        for (int j = rowIdx + 1; j < c2; ++j) {
            if (((AbstractPWDataGridRow)dataGrid.getOutputRow(j)).getCell(colIdx) == null) continue;
            isLastAtCol = false;
            break;
        }
        int colBorderTag = rowIdx == 0 ? (isLastAtCol ? 4369 : 4371) : (isLastAtCol ? 4401 : 4403);
        StyleAccess styleAccess = currentCell.getStyleAccess();
        styleAccess.merge(currentRow.getStyleAccess(), rowBorderTag);
        styleAccess.merge(currentCol.getStyleAccess(), colBorderTag);
        styleAccess.merge(dataGrid.getStyleAccess(), colBorderTag | rowBorderTag);
    }

    @Override
    protected String exportSpecial(IPrintWidget widget) {
        this.setNeedCalculateRelative(true);
        PWDataGrid outputGrid = (PWDataGrid)widget;
        if (this.statSet == null) {
            this.statSet = new GridStatSet(outputGrid);
        }
        int rowCount = outputGrid.getRowsCount();
        StringBuilder table = new StringBuilder();
        table.append("<table style=\"width:100%;\" border=\"unset\" cellspacing=\"0\">");
        this.addContent(table.toString());
        HtmlContext context = HtmlContext.get();
        while (outputGrid.getRowCursor() < rowCount) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(outputGrid.getRowCursor());
            row.setContext((ExecuteContext)outputGrid.getContext());
            if (row.getRowType() == 1) {
                this.executeTitleRow(outputGrid, (AbstractPWGridRow)row, false);
            } else if (row.getRowType() == 2) {
                R1PDataVisitor dataVisitor = this.getDataVisitor(outputGrid);
                if (dataVisitor == null) {
                    this.executeTitleRow(outputGrid, (AbstractPWGridRow)row, false);
                    outputGrid.addRowCursor();
                    continue;
                }
                CollectionField entryField = dataVisitor.getCollectionField(outputGrid.getDatasource(), outputGrid.getKey());
                PdIterator iterator = entryField.iterator();
                int rows = 0;
                while (iterator.hasNext() && ++rows <= this.getMaxRowNumber()) {
                    this.executeDetailRow(outputGrid, row, false, iterator);
                    if (!row.isRemainContent()) {
                        this.doStat(iterator);
                    }
                    iterator.next();
                }
            } else if (row.getRowType() == 3) {
                this.executeStatRow(outputGrid, row, true);
            }
            outputGrid.addRowCursor();
        }
        StringBuilder endTable = new StringBuilder();
        endTable.append("</table>");
        this.addContent(endTable.toString());
        return "";
    }

    private int getMaxRowNumber() {
        int maxRows = 100000;
        return SystemPropertyUtils.getInteger((String)ExecuteService.getTenantId(), (String)"new.print.max.rows", (Integer)maxRows);
    }

    protected void executeStatRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, boolean isStatic) {
        this.executeRow(outputGrid, (AbstractPWGridRow)row, isStatic, (ds, field) -> this.getStatVal(outputGrid, ds, (CellValueStat)field));
    }

    protected Field getStatVal(PWDataGrid outputGrid, String ds, CellValueStat cellField) {
        String gridds = outputGrid.getDatasource();
        if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds)) {
            return this.statSet.getStatValue(cellField.getField() + "_" + cellField.getStatType());
        }
        return this.getExporter().getExecuteHelper().getDataHelper().getFieldValue(ds, cellField.getField());
    }

    protected void doStat(PdIterator iterator) {
        if (this.statSet.hasStatField()) {
            this.statSet.doStats(iterator);
        }
    }

    @FunctionalInterface
    static interface GridDataVisitor {
        public Field getFormatVal(String var1, CellValueField var2);
    }
}

