/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html;

import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.execute.exporter.AR1PNode2HTML;
import kd.bos.print.core.execute.exporter.html.ContainerNode2HTML;
import kd.bos.print.core.execute.exporter.html.StringNode2HTML;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGrid;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridCell;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridColumn;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridRow;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.utils.HTMLUtils;

public class R1PLayoutGrid2HTML
extends AR1PNode2HTML {
    protected IPainter createViewt(IPrintWidget node) {
        return new Canvas();
    }

    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        StringNode2HTML cell_string_W2V = new StringNode2HTML();
        ContainerNode2HTML cell_container_W2V = new ContainerNode2HTML();
        cell_container_W2V.setExporter(this.getExporter());
        PWLayoutGrid layoutGrid = (PWLayoutGrid)widget;
        Canvas canvas = (Canvas)view;
        int addedX = 0;
        int addedY = 0;
        int rc = layoutGrid.getOutputRows().size();
        for (int r = 0; r < rc; ++r) {
            PWLayoutGridRow row = (PWLayoutGridRow)layoutGrid.getOutputRows().get(r);
            List cols = layoutGrid.getOutputColumns();
            addedX = 0;
            int cc = cols.size();
            for (int c = 0; c < cc; ++c) {
                PWLayoutGridColumn col = (PWLayoutGridColumn)cols.get(c);
                PWLayoutGridCell cell = (PWLayoutGridCell)row.getCell(c);
                if (cell != null && col.isPrintable()) {
                    R1PLayoutGrid2HTML.dealStyle(layoutGrid, row, col, cell, r, c);
                    IPainter cellView = null;
                    if (cell.hasChildren()) {
                        cell_container_W2V.setNode((IPrintWidget)cell);
                    } else {
                        cell_string_W2V.setNode((IPrintWidget)cell);
                    }
                    canvas.addPainter(cellView);
                }
                if (!col.isPrintable()) continue;
                addedX += col.getWidth();
            }
            addedY += row.getHeight();
        }
        canvas.setPainterSize((float)KDPrinterUtils.lomToPrintPoint(addedX) + 1.0f, (float)KDPrinterUtils.lomToPrintPoint(addedY) + 1.0f);
    }

    private static void dealStyle(PWLayoutGrid layoutGrid, PWLayoutGridRow currentRow, PWLayoutGridColumn currentCol, PWLayoutGridCell currentCell, int rowIdx, int colIdx) {
        boolean isLastAtRow = true;
        int c = layoutGrid.getColumnCount();
        for (int j = colIdx + 1; j < c; ++j) {
            if (currentRow.getCell(j) == null || !((PWLayoutGridColumn)layoutGrid.getColumn(j)).isPrintable()) continue;
            isLastAtRow = false;
            break;
        }
        int rowBorderTag = colIdx == 0 ? (isLastAtRow ? 4369 : 4881) : (isLastAtRow ? 12561 : 13073);
        boolean isLastAtCol = true;
        int c2 = layoutGrid.getRowsCount();
        for (int j = rowIdx + 1; j < c2; ++j) {
            if (((PWLayoutGridRow)layoutGrid.getRow(j)).getCell(colIdx) == null) continue;
            isLastAtCol = false;
            break;
        }
        int colBorderTag = rowIdx == 0 ? (isLastAtCol ? 4369 : 4371) : (isLastAtCol ? 4401 : 4403);
        StyleAccess styleAccess = currentCell.getStyleAccess();
        styleAccess.merge(currentRow.getStyleAccess(), rowBorderTag);
        styleAccess.merge(currentCol.getStyleAccess(), colBorderTag);
        styleAccess.merge(layoutGrid.getStyleAccess(), colBorderTag | rowBorderTag);
    }

    @Override
    protected String exportSpecial(IPrintWidget widget) {
        StringNode2HTML cellStringNode2Html = new StringNode2HTML();
        ContainerNode2HTML cellContainerNode2HTML = new ContainerNode2HTML();
        cellContainerNode2HTML.setExporter(this.getExporter());
        PWLayoutGrid layoutGrid = (PWLayoutGrid)widget;
        StringBuilder table = new StringBuilder();
        table.append("<table style=\"width:100%;\" border=\"unset\" cellspacing=\"0\">");
        this.addContent(table.toString());
        int addedX = 0;
        int addedY = 0;
        int rc = layoutGrid.getRowsCount();
        for (int r = 0; r < rc; ++r) {
            PWLayoutGridRow row = (PWLayoutGridRow)layoutGrid.getRow(r);
            StringBuilder tr = new StringBuilder();
            tr.append("<tr style=\"").append("height:").append(HTMLUtils.getHtmlConvertValue(row.getHeight())).append(";\">");
            this.addContent(tr.toString());
            addedX = 0;
            int cc = layoutGrid.getColumnCount();
            for (int c = 0; c < cc; ++c) {
                PWLayoutGridColumn col = (PWLayoutGridColumn)layoutGrid.getColumn(c);
                PWLayoutGridCell cell = (PWLayoutGridCell)row.getCell(c);
                String mergeString = HTMLUtils.getCellMergeString((AbstractPWGrid)layoutGrid, r, c);
                if ("NEED_INGORE".equals(mergeString)) continue;
                AbstractPWGridCell outputCell = (AbstractPWGridCell)cell.copy();
                Style wStyle = StyleAccess.getStyle((IPrintWidget)cell);
                int width = HTMLUtils.getWidthOfColumn((AbstractPWGrid)layoutGrid, r, c);
                String widthString = "width:" + HTMLUtils.getHtmlConvertValue(width) + ";";
                String borderString = HTMLUtils.getBoderTextByStyle(wStyle);
                String color = HTMLUtils.getBackground(wStyle);
                String styleString = " style=" + HTMLUtils.addDoubleQuotationMark(color + widthString + borderString);
                String alignString = HTMLUtils.getAlignStyle(wStyle);
                alignString = !"0".equals(alignString) ? " align=" + HTMLUtils.addDoubleQuotationMark(alignString) : "";
                this.addContent("<td" + mergeString + styleString + alignString + " >");
                if (cell != null && col.isPrintable()) {
                    R1PLayoutGrid2HTML.dealStyle(layoutGrid, row, col, cell, r, c);
                    Object cellView = null;
                    if (cell.hasChildren()) {
                        cellContainerNode2HTML.setNode((IPrintWidget)cell);
                        for (IPrintWidget childWidget : cell.getChildren()) {
                            if (!childWidget.isPrintable()) continue;
                            String child = this.getExporter().translate(childWidget, this.getExporter().getExecuteHelper(), true);
                            this.addContent(child);
                        }
                    } else {
                        cellStringNode2Html.setNode((IPrintWidget)cell);
                        String outputText = "";
                        ACellValue cellValue = cell.getCellValue();
                        if (cellValue instanceof CellValueField) {
                            String dataSource = outputCell.getDatasource();
                            CellValueField field = (CellValueField)cellValue;
                            Field fieldValue = this.getExporter().getExecuteHelper().getDataHelper().getFieldValue(dataSource, field.getField());
                            TextRunner runner = (TextRunner)outputCell.getRunner();
                            fieldValue = runner.formatOutputValue(fieldValue);
                            outputText = fieldValue.toString();
                            outputText = HTMLUtils.getTextByStyle(wStyle, outputText);
                            String convertText = HTMLUtils.getTextByStyle(wStyle, outputText);
                            this.addContent(convertText);
                        } else if (cellValue instanceof CellValueText) {
                            outputText = ((CellValueText)cellValue).getValue();
                            String convertText = HTMLUtils.getTextByStyle(wStyle, outputText);
                            this.addContent(convertText);
                        } else {
                            this.addContent(outputText);
                        }
                    }
                }
                if (col.isPrintable()) {
                    addedX += col.getWidth();
                }
                this.addContent("</td>");
            }
            addedY += row.getHeight();
            this.addContent("</tr>");
        }
        StringBuilder endTable = new StringBuilder();
        endTable.append("</table>");
        this.addContent(endTable.toString());
        return "";
    }

    protected R1PDataVisitor getDataVisitor(String datasource) {
        if (StringUtils.isBlank((CharSequence)datasource)) {
            return null;
        }
        IWidgetExecuteHelper.IDataHelper dataHelper = this.getExporter().getExecuteHelper().getDataHelper();
        R1PDataVisitor dataVisitor = dataHelper.getDataVisitor(datasource);
        return dataVisitor;
    }
}

