/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KDPrinterUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.execute.exporter.AR1PNode2HTML;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.ImageCell;
import kd.bos.print.core.model.ui.component.Page;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPage;

public class R1PPage2HTML
extends AR1PNode2HTML {
    private StyleAttributes _backgroundSa;

    protected IPainter createViewt(IPrintWidget node) {
        return new Page();
    }

    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        PWPage widgetPage = (PWPage)widget;
        Page printPage = (Page)view;
        byte[] background = widgetPage.getBackgroundPicture();
        if (background != null) {
            ImageCell imageCell = new ImageCell();
            imageCell.setImage(ImageUtil.makeImage((byte[])background));
            imageCell.setLayer(1);
            imageCell.setStyle(Styles.getStyle((ShareStyleAttributes)this.getBackgroundSa()));
            Point offset = widgetPage.getBackgroundOffset();
            float x = (float)KDPrinterUtils.lomToPrintPoint(offset.x);
            float y = (float)KDPrinterUtils.lomToPrintPoint(offset.y);
            float width = printPage.getWidth();
            float height = printPage.getHeight();
            imageCell.setPainterBounds(x, y, width - x, height - y);
            printPage.addPainter((IPainter)imageCell);
        }
    }

    @Override
    protected void exportChildren(IPrintWidget widget) {
        PWPage widgetPage = (PWPage)widget;
        if (widgetPage.hasChildren()) {
            List children = widgetPage.getChildren();
            children = children.stream().sorted((a, b) -> {
                if (b.getRectangle().getY() > a.getRectangle().getY()) {
                    return -1;
                }
                if (b.getRectangle().getY() < a.getRectangle().getY()) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            for (AbstractPrintWidget childWidget : children) {
                if (!childWidget.isPrintable()) continue;
                this.doBeforeExecuteChildren((IPrintWidget)widgetPage, (IPrintWidget)childWidget);
                String child = this.getExporter().translate((IPrintWidget)childWidget, this.getExporter().getExecuteHelper());
                this.addContent(child);
            }
        }
    }

    protected void doBeforeExecuteChildren(IPrintWidget container, IPrintWidget output) {
        Rectangle rectangle = container.getRectangle();
        int containerHeight = rectangle.height;
        int containerWidth = rectangle.width;
        int maxHeightToAdjust = containerHeight - output.getRectangle().y;
        output.getContext().setContainerWidth(containerWidth);
        output.getContext().setContainerHeight(containerHeight);
        output.getContext().setMaxHeightToAdjust(maxHeightToAdjust);
        output.setContainerHeight(containerHeight);
        output.setContainerWidth(containerWidth);
        output.setMaxHeightToAdjust(maxHeightToAdjust);
    }

    private StyleAttributes getBackgroundSa() {
        if (this._backgroundSa == null) {
            this._backgroundSa = Styles.getDefaultSA();
            this._backgroundSa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            this._backgroundSa.setVerticalAlign(Styles.VerticalAlignment.TOP);
        }
        return this._backgroundSa;
    }

    @Override
    protected String exportSpecial(IPrintWidget widget) {
        this.exportChildren(this.getNode());
        StringBuilder content = new StringBuilder();
        return content.toString();
    }
}

