/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html;

import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.execute.exporter.AR1PNode2HTML;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.ImageCell;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.utils.HTMLUtils;

public class R1PPicture2HTML
extends AR1PNode2HTML {
    private static final Log log = LogFactory.getLog(R1PPicture2HTML.class);

    protected IPainter createViewt(IPrintWidget node) {
        return new ImageCell();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] blobToBytes(Blob blob) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream is = blob.getBinaryStream();){
            if (is == null) return new byte[0];
            byte[] c = new byte[1024];
            int len = 0;
            while ((len = is.read(c, 0, c.length)) != -1) {
                baos.write(c, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (SQLException sQLException) {
            return new byte[0];
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }

    @Override
    protected String exportSpecial(IPrintWidget widget) {
        PWPicture output = (PWPicture)widget;
        byte[] content = null;
        Field outputValue = null;
        String ds = output.getDatasource();
        if (kd.bos.util.StringUtils.isEmpty((String)ds)) {
            byte[] imageByte;
            content = imageByte = this.getExporter().getExecuteHelper().getDataHelper().getImageByte(output.getBindField());
        } else {
            outputValue = this.getDataHelper((IPrintWidget)output, this.getExporter().getExecuteHelper(), ds).getFieldValue(ds, output.getBindField());
            content = R1PPicture2HTML.loadImage(outputValue);
        }
        Style wStyle = StyleAccess.getStyle((IPrintWidget)widget);
        String borderString = HTMLUtils.getBoderTextByStyle(wStyle);
        String baseBorder = "border: 1px solid;";
        this.setStyleString(baseBorder + borderString);
        if (content != null) {
            this.addContent(ImageUtil.getHtmlImageDisplayStringByBuytes((byte[])content));
            if (3 == output.getScaleType()) {
                output.setRectangle(ImageUtil.calculateAutomatic((byte[])content, (Rectangle)output.getRectangle()));
            }
        }
        return "picture";
    }

    private static byte[] loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = R1PPicture2HTML.blobToBytes((Blob)value);
            } else if (value instanceof ImageField) {
                String url = (String)((ImageField)value).getValue();
                if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
                    imageData = ImageUtil.getImageByUrl((String)((String)((ImageField)value).getValue()));
                }
            } else if (value instanceof String && StringUtils.isNotBlank((Object)value)) {
                imageData = ImageUtil.getImageByUrl((String)((String)value));
            }
            return imageData;
        }
        return null;
    }
}

