/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html;

import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.Locale;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.ctrl.reportone.r1.print.common.AdjustHeightRenderer;
import kd.bos.print.core.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import kd.bos.print.core.ctrl.reportone.r1.print.common.currency.CurrencyFormatManager;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.data.Language;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.R1PrintEngine;
import kd.bos.print.core.execute.exporter.AR1PNode2HTML;
import kd.bos.print.core.model.CurrencyFormat;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.R1PLabelCell;
import kd.bos.print.core.model.ui.component.VariantLabelCell;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.utils.HTMLUtils;
import kd.bos.print.core.utils.HtmlContext;
import kd.bos.print.core.utils.HtmlExportUtils;
import org.apache.commons.lang3.StringUtils;

class StringNode2HTML
extends AR1PNode2HTML {
    StringNode2HTML() {
    }

    protected IPainter createViewt(IPrintWidget node) {
        AbstractPrintWidgetText widgetText = (AbstractPrintWidgetText)node;
        String text = widgetText.getOutputText();
        if (text != null && text.startsWith("&[") && text.endsWith("]")) {
            VariantLabelCell vlc = new VariantLabelCell();
            vlc.setText(text);
            return vlc;
        }
        return new R1PLabelCell();
    }

    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        if (view instanceof R1PLabelCell) {
            AbstractPrintWidgetText widgetText = (AbstractPrintWidgetText)widget;
            R1PLabelCell labelCell = (R1PLabelCell)view;
            labelCell.setText(widgetText.getOutputText());
            labelCell.setDivideCharNums(widgetText.getDivideCharNums());
            labelCell.setDivideModel(widgetText.getDivideModel());
            if (widget instanceof IAdjustHeightRenderSupport) {
                labelCell.setUseAdjustHeightRender(((IAdjustHeightRenderSupport)widget).isUseAdjustHeightRender());
            }
        }
    }

    @Override
    protected String exportSpecial(IPrintWidget widget) {
        String text;
        AdjustHeightRenderer.Result result;
        int lastHeight;
        Object formulaResult;
        String ds;
        PWText output = (PWText)widget;
        Style wStyle = StyleAccess.getStyle((IPrintWidget)widget);
        this.setOverFlow(!output.isAdjustHeight());
        this.getExporter().getExecuteHelper().markOutputId((IPrintWidget)output);
        Object outputValue = null;
        boolean isStatic = StringUtil.isEmptyString((String)output.getDatasource());
        Field opValue = output.getOutputValue();
        outputValue = opValue != null ? opValue : (isStatic ? new TextField(output.getBindField()) : (StringUtil.equals((String)(ds = output.getDatasource()), (String)"$DsKey=[System]") ? new TextField((formulaResult = R1PrintEngine.runFormula(this.getExporter().getExecuteHelper(), (IPrintWidget)output, output.getBindField())) == null ? "" : formulaResult.toString()) : this.getDataHelper((IPrintWidget)output, this.getExporter().getExecuteHelper(), ds).getFieldValue(ds, output.getBindField())));
        Rectangle rectangle = output.getRectangle();
        int height = (int)rectangle.getHeight();
        int width = (int)rectangle.getWidth();
        outputValue = this.formatOutputValue(output, (Field)outputValue);
        int maxHeight = Util.lom2Pixel((int)output.getMaxHeightToAdjust()) - 1;
        if (maxHeight < 0) {
            maxHeight = Util.lom2Pixel((int)output.getRectangle().height);
        }
        if ((double)(lastHeight = (result = AdjustHeightRenderer.adjustHeight(text = outputValue.getShowValue() == null ? "" : outputValue.getShowValue().toString(), wStyle, Util.lom2Pixel((int)height), maxHeight, Util.lom2Pixel((int)width))).getUsedHeight()) < output.getRectangle().getHeight()) {
            lastHeight = (int)output.getRectangle().getHeight();
        }
        int usedHeight = Util.pixel2Lom((int)lastHeight);
        if (output.isAdjustHeight() & output.isRichtext()) {
            int realHeight = HTMLUtils.getRealMM(HTMLUtils.getPapaerHeight(HtmlContext.get().getPrintInfo()));
            lastHeight = HTMLUtils.getHeight(outputValue.toString(), HTMLUtils.getRealMM(output.getRectangle().getWidth()), realHeight);
            lastHeight = Util.lom2Pixel((int)lastHeight);
        } else {
            lastHeight = output.isAdjustHeight() ? usedHeight : height;
        }
        output.getRectangle().setRect(output.getRectangle().x, output.getRectangle().y, output.getRectangle().getWidth(), lastHeight);
        StringBuilder content = new StringBuilder();
        String borderString = HTMLUtils.getBoderTextByStyle(wStyle);
        String baseBorder = "border: 1px solid;";
        this.setStyleString(baseBorder + borderString);
        StringBuilder style = new StringBuilder();
        style.append("text-align:").append(HTMLUtils.getAlignStyle(wStyle)).append(";");
        style.append("word-wrap: break-word;line-height:90%; ");
        if (!output.isRichtext()) {
            int offsetY = 0;
            if (wStyle.getVerticalAlign() == Styles.VerticalAlignment.TOP) {
                offsetY = 0;
                offsetY += wStyle.getPadding().getTop() * 10;
            } else {
                result = AdjustHeightRenderer.adjustHeight(text, wStyle, 0, maxHeight, Util.lom2Pixel((int)width));
                offsetY = wStyle.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE ? (output.getRectangle().height - Util.pixel2Lom((int)result.getUsedHeight())) / 2 : output.getRectangle().height - Util.pixel2Lom((int)result.getUsedHeight());
            }
            style.append("padding-top:").append(HTMLUtils.getHtmlConvertValue(offsetY)).append(";");
        }
        content.append("<div ").append("style= ").append(HTMLUtils.addDoubleQuotationMark(style.toString())).append(">");
        if (this.needCalculate() && StringUtils.isNotEmpty((CharSequence)outputValue.toString())) {
            this.setNeedCalculateRelative(true);
        }
        if (!output.isRichtext()) {
            String convertText = HTMLUtils.getTextByStyle(wStyle, outputValue.toString());
            content.append(HtmlExportUtils.getFontsConverted(convertText, ExecuteService.getTenantId()));
        } else {
            content.append(HtmlExportUtils.getFontsConverted(outputValue.toString(), ExecuteService.getTenantId()));
        }
        content.append("</div>");
        this.addContent(content.toString());
        return "";
    }

    private boolean needCalculate() {
        return !this.isOverFlow();
    }

    private void outputAdjustWidget(PWText output, String text) {
        String textToDraw;
        Rectangle rectangle = output.getRectangle();
        int height = (int)rectangle.getHeight();
        int width = (int)rectangle.getWidth();
        int maxHeight = Util.lom2Pixel((int)output.getMaxHeightToAdjust()) - 1;
        AdjustHeightRenderer.Result result = AdjustHeightRenderer.adjustHeight(text = text == null ? "" : text, StyleAccess.getStyle((IPrintWidget)output), Util.lom2Pixel((int)height), maxHeight, Util.lom2Pixel((int)width));
        if (result.isTextCutOff()) {
            int nextStart = result.getCutPosition();
            textToDraw = text.substring(0, nextStart);
            String textRemain = text.substring(nextStart);
        } else {
            textToDraw = text;
            Object textRemain = null;
        }
        int usedHeight = Util.pixel2Lom((int)result.getUsedHeight());
        output.setOutputText(textToDraw);
        output.getRectangle().setRect(rectangle.getX(), rectangle.getY(), width, usedHeight);
    }

    public Field formatOutputValue(PWText outputWidget, Field outputValue) {
        String format;
        String textFormat = outputWidget.getTextFormat();
        if ((outputValue = super.formatOutputValue(outputValue)) instanceof NullField) {
            return outputValue;
        }
        if ("Number".equalsIgnoreCase(textFormat) && StringUtils.isNotEmpty((CharSequence)outputValue.toString()) && kd.bos.util.StringUtils.isNumeric((String)String.valueOf(outputValue.toString()))) {
            outputValue = this.formatNumber(outputValue, outputWidget);
        } else if ("Amount".equalsIgnoreCase(textFormat)) {
            outputValue = this.fortmatAmount(outputValue, outputWidget);
        } else if (("Date".equals(textFormat) || "Time".equals(textFormat)) && !StringUtil.equals((String)(format = this.getFormat(outputWidget.getFormat(), outputValue)), (String)"-")) {
            FormatResult result = Formats.getFormat((String)format).format(new Variant(outputValue.getValue()));
            outputValue = new TextField(result.toString());
        }
        return outputValue;
    }

    protected String getFormat(String tplSetFormat, Field outputValue) {
        if (!StringUtil.equals((String)tplSetFormat, (String)"-")) {
            return tplSetFormat;
        }
        String format = outputValue.getFormat();
        if (StringUtil.isEmptyString((String)format)) {
            return tplSetFormat;
        }
        return format;
    }

    private Field formatNumber(Field outputValue, PWText outputWidget) {
        String nativeFormat;
        int c;
        BigDecimal bigDecimal = this.toBigDecimal(outputValue.getValue());
        if (outputWidget.isIgnoreZero() && (c = bigDecimal.compareTo(BigDecimal.ZERO)) == 0) {
            return NullField.get();
        }
        if (outputWidget.isShowPercentage()) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(100L));
        }
        if (StringUtils.isBlank((CharSequence)(nativeFormat = outputWidget.getNegativeType()))) {
            nativeFormat = "-";
        }
        char decimalPoint = '.';
        char numSeparator = ',';
        String numGroupFormat = "###,###";
        int scale = outputWidget.getPrecision();
        if (scale == -1 && outputValue instanceof DecimalField) {
            DecimalField decimalField = (DecimalField)outputValue;
            scale = decimalField.getScale();
        }
        NumberFormatObject numberformatObj = new NumberFormatObject(decimalPoint, numSeparator, "", numGroupFormat, nativeFormat);
        numberformatObj.setGroupingUsed(outputWidget.isThousandSplit());
        String str = this.formatNumber(bigDecimal, numberformatObj, outputWidget.isIgnoreTailZero(), scale);
        outputValue = outputWidget.isShowPercentage() ? new TextField(str + "%") : new TextField(str);
        return outputValue;
    }

    private Field fortmatAmount(Field outputValue, PWText outputWidget) {
        Field formatField;
        StringBuilder outputText = new StringBuilder();
        outputWidget.setShowPercentage(Boolean.FALSE.booleanValue());
        CurrencyFormat currencyFormat = outputWidget.getCurrencyFormat();
        boolean isUppercase = currencyFormat.isUppercase();
        boolean showCurrency = currencyFormat.isShowCurrency();
        CurrencyFormatManager formater = CurrencyFormatManager.shareInstance();
        String currencyCode = currencyFormat.getCurrencyCode();
        boolean isFormCurrency = "FROM_CURRENCY".equals(currencyCode);
        if (isFormCurrency && outputValue instanceof DecimalField) {
            DecimalField decimalField = (DecimalField)outputValue;
            currencyCode = decimalField.getCode();
        }
        if (StringUtils.isEmpty((CharSequence)currencyCode)) {
            showCurrency = false;
        }
        if ((formatField = this.formatNumber(outputValue, outputWidget)) instanceof NullField) {
            return formatField;
        }
        if (isUppercase) {
            Language language = Language.getLanguage(ExecuteContext.get().getLang());
            Locale localeLang = Locale.SIMPLIFIED_CHINESE;
            if (language != null) {
                localeLang = language.getLocale();
            }
            outputText.append(formater.upperFomat(currencyCode, localeLang, new Variant((Object)formatField.toString()), showCurrency));
        } else {
            String currencySymbol = "";
            outputText.append(formatField.toString());
            if (showCurrency) {
                if (isFormCurrency && outputValue instanceof DecimalField) {
                    DecimalField decimalField = (DecimalField)outputValue;
                    currencySymbol = decimalField.getSymbol();
                } else {
                    currencySymbol = formater.getSymbol(currencyCode);
                }
                if (StringUtils.isNotEmpty((CharSequence)currencySymbol)) {
                    outputText.insert(0, currencySymbol);
                }
            }
        }
        return new TextField(outputText.toString());
    }
}

