/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html.render;

import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.execute.exporter.html.render.RowCols;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;

public class TableMergeRender {
    AbstractPWGrid grid = null;
    boolean isCalculated = false;
    Map<String, RowCols> allMerged = new HashMap<String, RowCols>();
    Map<String, Integer> widthMap = new HashMap<String, Integer>();

    public TableMergeRender(AbstractPWGrid grid) {
        this.grid = grid;
    }

    public RowCols getRowsObject(int row, int col) {
        RowCols retrunValue = null;
        if (!this.isCalculated) {
            this.calculateMergeResult();
        }
        String queryKey = this.getQueryKey(row, col);
        retrunValue = this.allMerged.get(queryKey);
        return retrunValue;
    }

    public int getWidthOfColumn(int row, int col) {
        String queryKey;
        Integer width;
        if (!this.isCalculated) {
            this.calculateMergeResult();
        }
        if ((width = this.widthMap.get(queryKey = this.getQueryKey(row, col))) == null) {
            width = -1;
        }
        return width;
    }

    private void calculateMergeResult() {
        if (this.grid != null && this.grid.getColumnCount() >= 1 && this.grid.getRowsCount() >= 1 && this.grid.getMergeBlocks() != null) {
            Map mergeBlocks = this.grid.getMergeBlocks();
            for (Map.Entry entry : mergeBlocks.entrySet()) {
                MergeBlock block = (MergeBlock)entry.getValue();
                int columnStart = block.getLeft();
                int colunmEnd = block.getRight();
                int rowStart = block.getTop();
                int rowEnd = block.getBottom();
                int totalRows = 1;
                int totalColumn = 1;
                String key = this.getQueryKey(rowStart, columnStart);
                if (this.getMergeValue(rowStart, rowEnd) > 1) {
                    totalRows = this.getMergeValue(rowStart, rowEnd);
                }
                if (this.getMergeValue(columnStart, colunmEnd) > 1) {
                    totalColumn = this.getMergeValue(columnStart, colunmEnd);
                    AbstractPWGridColumn col = this.grid.getColumn(columnStart);
                    int totalWidth = col.getWidth();
                    for (int i = columnStart + 1; i <= colunmEnd; ++i) {
                        AbstractPWGridColumn column = this.grid.getColumn(columnStart);
                        totalWidth += column.getWidth();
                    }
                    this.widthMap.put(key, totalWidth);
                }
                this.allMerged.put(key, new RowCols(totalRows, totalColumn));
                if (totalColumn > 1) {
                    for (int i = columnStart + 1; i <= colunmEnd; ++i) {
                        String nonkey = this.getQueryKey(rowStart, i);
                        this.allMerged.put(nonkey, new RowCols(-1, -1));
                    }
                }
                if (totalRows <= 1) continue;
                for (int i = rowStart + 1; i <= rowEnd; ++i) {
                    String nonkey = this.getQueryKey(i, columnStart);
                    this.allMerged.put(nonkey, new RowCols(-1, -1));
                }
            }
        }
        this.isCalculated = true;
    }

    private int getMergeValue(int rowStart, int rowEnd) {
        return rowEnd - rowStart + 1;
    }

    private String getQueryKey(int i, int j) {
        return i + "_" + j;
    }
}

