/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.html.render;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.execute.exporter.html.Attribute;
import kd.bos.print.core.model.widget.StyleAccess;
import org.apache.commons.lang3.StringUtils;

public class TextRender {
    List<Attribute> sAttributs = new ArrayList<Attribute>();

    private void addAttribute(Attribute attribute) {
        if (attribute != null) {
            this.sAttributs.add(attribute);
        }
    }

    private String getAttributesHeadString() {
        StringBuilder sb = new StringBuilder();
        for (Attribute attribute : this.sAttributs) {
            if (StringUtils.isNotEmpty((CharSequence)attribute.getValue())) {
                sb.append("<span style=\"").append(attribute.getName()).append(":").append(attribute.getValue()).append("\">");
                continue;
            }
            sb.append("<").append(attribute.getName()).append(">");
        }
        return sb.toString();
    }

    private String getAttributesTailString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.sAttributs.size() - 1; i >= 0; --i) {
            Attribute attribute = this.sAttributs.get(i);
            if (StringUtils.isNotEmpty((CharSequence)attribute.getValue())) {
                sb.append("</span>");
                continue;
            }
            sb.append("</").append(attribute.getName()).append(">");
        }
        return sb.toString();
    }

    public String getTextByStyle(Style wStyle, String outputValue) {
        int order = 1;
        if (wStyle.getFont() != null) {
            StringBuilder fontBuilder = new StringBuilder(wStyle.getFont().getFontName());
            fontBuilder.append(",").append(wStyle.getFont().getFamily(Locale.ENGLISH));
            this.addAttribute(new Attribute("font-family", fontBuilder.toString(), order++));
        }
        this.addAttribute(new Attribute("font-size", wStyle.getFontSizeF() + "px", order++));
        Color fontColor = wStyle.getFontColor();
        if (fontColor != null) {
            this.addAttribute(new Attribute("color", StyleAccess.color2string((Color)fontColor), order++));
        }
        if (wStyle.isUnderline()) {
            this.addAttribute(new Attribute("text-decoration", "underline", order++));
        }
        if (wStyle.isBold()) {
            this.addAttribute(new Attribute("strong", null, order++));
        }
        if (wStyle.isItalic()) {
            this.addAttribute(new Attribute("em", null, order++));
        }
        this.sortAttribut();
        StringBuilder sb = new StringBuilder(this.getAttributesHeadString());
        sb.append(outputValue);
        sb.append(this.getAttributesTailString());
        return sb.toString();
    }

    private void sortAttribut() {
        Collections.sort(this.sAttributs);
    }
}

