/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model;

import kd.bos.print.core.model.UppercaseType;

public enum UpperCurrencySymbol {
    ZH_UPPER_CNY("CNY", UppercaseType.ZH_UPPER, "\u00a5"),
    EN_UPPER_CNY("CNY", UppercaseType.EN_UPPER, "SAY CHINESE YUAN "),
    ZH_UPPER_USD("USD", UppercaseType.ZH_UPPER, "$"),
    EN_UPPER_USD("USD", UppercaseType.EN_UPPER, "SAY US DOLLARS "),
    ZH_UPPER_HKD("HKD", UppercaseType.ZH_UPPER, "HK$"),
    EN_UPPER_HKD("HKD", UppercaseType.EN_UPPER, "SAY HONG KONG DOLLARS ");

    private String currencyCode;
    private UppercaseType uppercaseType;
    private String symbol;

    private UpperCurrencySymbol(String currencyCode, UppercaseType uppercaseType, String symbol) {
        this.currencyCode = currencyCode;
        this.uppercaseType = uppercaseType;
        this.symbol = symbol;
    }

    public static String getCurrencySymbol(String currencyCode, UppercaseType uppercaseType) {
        for (UpperCurrencySymbol value : UpperCurrencySymbol.values()) {
            if (!value.currencyCode.equals(currencyCode) || value.uppercaseType != uppercaseType) continue;
            return value.symbol;
        }
        return "";
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public UppercaseType getUppercaseType() {
        return this.uppercaseType;
    }

    public void setUppercaseType(UppercaseType uppercaseType) {
        this.uppercaseType = uppercaseType;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }
}

