/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import kd.bos.print.core.ctrl.kdf.headfootdesigner.HeadFootModel;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.HeadFootCell;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.MixVariantLabelCell;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.component.Paper;

public class HeaderFooter
extends Canvas {
    protected static int LEFT_SPAN = 1;
    protected int colSpan = 10;
    protected HeadFootModel model;
    protected boolean valid = false;
    HeadFootCell[][] cellss;
    private static float TOP_SPAN = 1.0f;

    public Object copy() {
        HeaderFooter cloneObj = new HeaderFooter();
        cloneObj.setPainterBounds(this.getPainterBounds());
        cloneObj.setModel(this.getModel());
        cloneObj.setPainterInfo(this.getPainterInfo());
        return cloneObj;
    }

    public void painting(Graphics g, PainterInfo info2) {
        PainterInfo info = info2;
        if (this.getPainterInfo() != null) {
            info = this.getPainterInfo();
        }
        this.valid = true;
        if (this.cellss == null) {
            this.cellss = HeadFootCell.parseModel(this.model);
        }
        if (this.cellss != null) {
            this.removeAllPainter();
            int x = LEFT_SPAN;
            float y = this.initY();
            int w = 0;
            int h = 0;
            float maxW = (float)this.getPainterSize().getWidth();
            for (HeadFootCell[] cells : this.cellss) {
                int cols = cells.length;
                x = LEFT_SPAN;
                if (cols == 0) continue;
                float colWidth = cols == 1 ? maxW : (maxW - (float)((cols - 1) * this.colSpan)) / (float)cols;
                for (int j = 0; j < cols; ++j) {
                    HeadFootCell cell = cells[j];
                    Dimension size = cell.getSize(g, info);
                    w = size.width;
                    h = size.height;
                    y = this.updateY(j, y, h);
                    MixVariantLabelCell lc = new MixVariantLabelCell();
                    lc.setText(cell.getText());
                    lc.setStyle(cell.getStyle());
                    Rectangle2D.Float rect = new Rectangle2D.Float();
                    rect.x = (float)x + (colWidth + (float)this.colSpan) * (float)j;
                    rect.y = y;
                    rect.width = colWidth;
                    rect.height = h;
                    if (j == 0) {
                        if (cols > 1) {
                            this.setLeftCellBounds((IPainter)lc, rect, w, h);
                            continue;
                        }
                        this.setCellBounds((IPainter)lc, rect, w, h);
                        continue;
                    }
                    if (j == cols - 1) {
                        this.setRightCellBounds((IPainter)lc, rect, w, h);
                        continue;
                    }
                    this.setCellBounds((IPainter)lc, rect, w, h);
                }
                y = this.nextY(y, h);
            }
        }
        super.painting(g, info);
    }

    public static float getActiveHeight(Graphics g, PainterInfo info, HeadFootModel model) {
        float height = 0.0f;
        HeadFootCell[][] thecellss = null;
        if (thecellss == null) {
            thecellss = HeadFootCell.parseModel(model);
        }
        if (thecellss == null) {
            return height;
        }
        for (HeadFootCell[] cells : thecellss) {
            int cols = cells.length;
            if (cols == 0) continue;
            HeadFootCell cell = cells[0];
            Dimension size = cell.getSize(g, info);
            height += (float)size.height;
        }
        return height;
    }

    public HeadFootModel getModel() {
        return this.model;
    }

    public void setModel(HeadFootModel model) {
        this.model = model;
        this.valid = false;
        this.cellss = null;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    protected void setCellBounds(IPainter cell, Rectangle2D.Float rect, int w, int h) {
        float span = (rect.width - (float)w) / 2.0f;
        if (span < 0.0f) {
            span = 0.0f;
        }
        rect.x += span;
        rect.width = w;
        rect.height = h;
        cell.setPainterBounds(rect);
        this.addPainter(cell);
    }

    protected void setLeftCellBounds(IPainter cell, Rectangle2D.Float rect, int w, int h) {
        rect.x += 0.0f;
        rect.width = w;
        rect.height = h;
        Style style = cell.getStyle();
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)style);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        Style thestyle = Styles.getStyle((ShareStyleAttributes)sa);
        cell.setStyle(thestyle);
        cell.setPainterBounds(rect);
        this.addPainter(cell);
    }

    protected void setRightCellBounds(IPainter cell, Rectangle2D.Float rect, int w, int h) {
        float span = rect.width - (float)w;
        if (span < 0.0f) {
            span = 0.0f;
        }
        rect.x += span;
        rect.width = w;
        rect.height = h;
        Style style = cell.getStyle();
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)style);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        Style thestyle = Styles.getStyle((ShareStyleAttributes)sa);
        cell.setStyle(thestyle);
        cell.setPainterBounds(rect);
        this.addPainter(cell);
    }

    protected float initY() {
        return TOP_SPAN;
    }

    protected float updateY(int j, float y, int h) {
        return y;
    }

    protected float nextY(float y, int h) {
        return y += (float)h;
    }

    public void adjustFooterBounds(Paper paper, Graphics g, PainterInfo info) {
        int footAlign = (Integer)info.invokeGet("getFooterAlign");
        int headAlign = (Integer)info.invokeGet("getHeaderAlign");
        if (footAlign == 0) {
            float height = HeaderFooter.getActiveHeight(g, info, this.model);
            Rectangle2D.Float bounds = this.getPainterBounds();
            float newy = bounds.y - (height - bounds.height);
            float width = headAlign == 1 ? paper.getBody().getPainterBounds().width : bounds.width;
            this.setPainterLocation(bounds.x, newy);
            this.setPainterSize(width, height);
        } else {
            Rectangle2D.Float rectFloat = paper.getBody().getPainterBounds();
            Rectangle2D.Float bounds = this.getPainterBounds();
            double scale = info.getScaleY();
            if (scale != 1.0) {
                rectFloat.height = (float)((double)rectFloat.height * scale);
            }
            float newy = rectFloat.y + rectFloat.height + 2.0f;
            float height = HeaderFooter.getActiveHeight(g, info, this.model);
            float width = headAlign == 1 ? rectFloat.width : bounds.width;
            this.setPainterLocation(bounds.x, newy);
            this.setPainterSize(width, height);
        }
    }

    public void adjustHeaderBounds(Paper paper, Graphics g, PainterInfo info) {
        int headAlign = (Integer)info.invokeGet("getHeaderAlign");
        if (headAlign == 0) {
            float height = HeaderFooter.getActiveHeight(g, info, this.model);
            this.setPainterSize(this.getPainterBounds().width, height);
        } else {
            float width = paper.getBody().getPainterBounds().width;
            float height = HeaderFooter.getActiveHeight(g, info, this.model);
            this.setPainterSize(width, height);
        }
    }
}

