/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.LineCell;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.view.BasicPainterView;

public class LineCellView
extends BasicPainterView {
    protected static LineCellView ui = new LineCellView();
    protected static Style defaultStyle;

    public static BasicPainterView createPainterView() {
        return ui;
    }

    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        LineCell cell = (LineCell)painter;
        Color color = cell.getColor();
        if (color != null) {
            g.setColor(color);
        }
        float topX = painter.getX();
        float topY = painter.getY();
        float x1 = cell.getX1() - topX;
        float y1 = cell.getY1() - topY;
        float x2 = cell.getX2() - topX;
        float y2 = cell.getY2() - topY;
        Style style = painter.getStyle();
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        if (style != null) {
            g.setColor(style.getBorderColor(Styles.Position.LEFT));
            Stroke stroke = style.getStroke(Styles.Position.LEFT);
            ((Graphics2D)g).setStroke(stroke);
        }
        Line2D.Float line = new Line2D.Float(x1, y1, x2, y2);
        if (cell.isUseInt()) {
            line.x1 = (int)line.x1;
            line.x2 = (int)line.x2;
            line.y1 = (int)line.y1;
            line.y2 = (int)line.y2;
        }
        ((Graphics2D)g).draw(line);
        ((Graphics2D)g).setStroke(oldStroke);
    }

    static {
        StyleAttributes ssa = Styles.getEmptySA();
        ssa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        defaultStyle = Styles.getStyle((ShareStyleAttributes)ssa);
    }
}

