/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kd.bos.print.core.ctrl.kdf.util.render.IBorderHolder;
import kd.bos.print.core.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.component.StyleCell;
import kd.bos.print.core.model.ui.view.BasicPainterView;
import kd.bos.print.core.model.ui.view.StyleRender;

public class StyleCellView
extends BasicPainterView {
    protected static StyleCellView labelUI = new StyleCellView();
    Rectangle2D.Float cellRect = new Rectangle2D.Float();
    Rectangle2D.Float borderRect = new Rectangle2D.Float();

    public static BasicPainterView createPainterView() {
        return labelUI;
    }

    private Rectangle2D.Float getCellRect(Rectangle2D.Float borderRect, int borderSpace) {
        float spp = 0.9999f;
        this.cellRect.x = borderRect.x + (float)borderSpace + spp;
        this.cellRect.y = borderRect.y + (float)borderSpace + spp;
        this.cellRect.width = borderRect.width - (float)(2 * borderSpace) - spp;
        this.cellRect.height = borderRect.height - (float)(2 * borderSpace) - spp;
        return this.cellRect;
    }

    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        StyleCell sheetCell = (StyleCell)painter;
        this.borderRect.setRect(0.0f, 0.0f, (float)sheetCell.getPainterSize().getWidth(), (float)sheetCell.getPainterSize().getHeight());
        Rectangle2D.Float theCellRect = this.getCellRect(this.borderRect, sheetCell.getBorderSpace());
        Color backColor = painter.getBackGround();
        if (backColor != null && backColor.getAlpha() == 255) {
            Color old = g.getColor();
            g.setColor(backColor);
            ((Graphics2D)g).fill(theCellRect);
            g.setColor(old);
        }
        boolean isBlackWhite = sheetCell.isBlackWhite();
        StyleRender.setBlackWhite((boolean)isBlackWhite);
        StyleRender.getBorderRender2().setBlackWhite(isBlackWhite);
        Graphics2D g2d = (Graphics2D)g;
        Style style = painter.getStyle();
        if (style == null) {
            style = Styles.getDefaultStyle();
        }
        StyleRender.getCellBackRender().draw((Graphics)g2d, (Shape)this.borderRect, null, style);
        int space = sheetCell.getTextSpace();
        theCellRect.setRect(theCellRect.getX() + (double)space, theCellRect.getY(), theCellRect.getWidth() - (double)(2 * space), theCellRect.getHeight());
        ArrayList customRenders = sheetCell.getCustomRenders();
        if (customRenders != null && customRenders.size() > 0) {
            int size = customRenders.size();
            for (int i = 0; i < size; ++i) {
                ((StyleCell.AbstractCustomRenderWrapper)customRenders.get(i)).draw(g2d, theCellRect, sheetCell.getDisplayText(graInfo), style);
            }
        } else {
            StyleRender.drawText((Graphics)g, (Rectangle2D)theCellRect, (String)sheetCell.getDisplayText(graInfo), (Style)style, (int)graInfo.getEncode());
        }
        AbstractTableSplitRectInfo splitInfo = sheetCell.getDiagonalInfo();
        if (splitInfo != null) {
            StyleRender.drawSplitRectText((Graphics2D)g2d, (Rectangle2D.Float)this.borderRect, (Object)splitInfo);
        }
        StyleRender.getBorderRender2().setHolder((IBorderHolder)painter);
        StyleRender.getBorderRender2().draw((Graphics)g2d, (Shape)this.borderRect, (Object)sheetCell.getBorderInfo(), style);
    }
}

