/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.loop;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import kd.bos.print.core.execute.ExecuteContext;
import kd.bos.print.core.model.IDatasourceSupport;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IAdjustHeightSupport;
import kd.bos.print.core.model.widget.IPaginationSupport;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.loop.DataTransposer;
import kd.bos.print.core.model.widget.loop.PWLoopContainer;
import kd.bos.print.core.model.widget.loop.TransposedDataHelper;
import kd.bos.print.core.model.widget.loop.context.LoopAreaContext;

public class PWLoopArea
extends AbstractPrintWidget
implements IAdjustHeightSupport,
IDatasourceSupport,
IPaginationSupport {
    public static final boolean Orientation_H = true;
    public static final boolean Orientation_V = false;
    private PWLoopContainer _container;
    private String _ds;
    private boolean _loopOrientation;
    private boolean _isAdjustHeight;
    private boolean _toUseOutWidth;
    private boolean _blankRowStrategy;
    private DataTransposer _transpose;
    private int _maxHeightToAdjust;
    private ArrayList _outputContainers;
    private int _maxRowIdx;
    private int _maxColIdx;

    public IPrintWidget copy() {
        PWLoopArea outputArea = (PWLoopArea)super.copy();
        outputArea._container = (PWLoopContainer)this._container.copy();
        outputArea._ds = this._ds;
        outputArea._loopOrientation = this._loopOrientation;
        outputArea._isAdjustHeight = this._isAdjustHeight;
        outputArea._toUseOutWidth = this._toUseOutWidth;
        outputArea._blankRowStrategy = this._blankRowStrategy;
        return outputArea;
    }

    public ExecuteContext getContext() {
        return this.getMyContext();
    }

    LoopAreaContext getMyContext() {
        if (this._executeContext == null) {
            this._executeContext = new LoopAreaContext(this.getDatasource());
        }
        return (LoopAreaContext)this._executeContext;
    }

    private void adjustWidth(PWLoopArea outputArea, int areaWidth, int widthUsed) {
        if (outputArea.isToUseOutWidth() && widthUsed < areaWidth) {
            int allDelta = areaWidth - widthUsed;
            int unitDelta = allDelta / outputArea.getOutputColsCount();
            int repairIdx = allDelta % outputArea.getOutputColsCount();
            for (PWLoopContainer outputCtn : outputArea.getOutputContainers()) {
                int idx;
                int xAdd = idx * unitDelta + ((idx = outputCtn.getColIdx()) < repairIdx ? idx : repairIdx);
                int delta = unitDelta + (idx < repairIdx ? 1 : 0);
                Rectangle rect = outputCtn.getRectangle();
                rect.x += xAdd;
                rect.width += delta;
            }
        }
    }

    private void updateRowColCount(int rowIdx, int colIdx) {
        if (rowIdx > this._maxRowIdx) {
            this._maxRowIdx = rowIdx;
        }
        if (colIdx > this._maxColIdx) {
            this._maxColIdx = colIdx;
        }
    }

    private IWidgetExecuteHelper.IDataHelper createTansposedDataHelper(IWidgetExecuteHelper helper) throws R1PrintDataException {
        if (this._transpose != null) {
            List<DynamicObject> rowSet = this._transpose.trans(helper.getDataHelper(), this.getDatasource());
            return new TransposedDataHelper(rowSet);
        }
        return null;
    }

    public int getOutputRowsCount() {
        return this._maxRowIdx + 1;
    }

    public int getOutputColsCount() {
        return this._maxColIdx + 1;
    }

    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    public void setRemainContent(boolean isRemain) {
    }

    public boolean isRemainContent() {
        return false;
    }

    public void setDatasource(String ds) {
        this._ds = ds;
    }

    public String getDatasource() {
        return this._ds;
    }

    public void setTranspose(DataTransposer transpose) {
        this._transpose = transpose;
    }

    public DataTransposer getTranspose() {
        return this._transpose;
    }

    public void setLoopContainer(PWLoopContainer ctn) {
        this._container = ctn;
    }

    public PWLoopContainer getLoopContainer() {
        return this._container;
    }

    public void setLoopOrientation(boolean orientation) {
        this._loopOrientation = orientation;
    }

    public boolean getLoopOrientation() {
        return this._loopOrientation;
    }

    public void setBlankRowStrategy(boolean isBlankRowStrategy) {
        this._blankRowStrategy = isBlankRowStrategy;
    }

    public boolean isBlankRowStrategy() {
        return this._blankRowStrategy;
    }

    public void setToUseOutWidth(boolean toUseOutWidth) {
        this._toUseOutWidth = toUseOutWidth;
    }

    public boolean isToUseOutWidth() {
        return this._toUseOutWidth;
    }

    public List getOutputContainers() {
        if (this._outputContainers == null) {
            this._outputContainers = new ArrayList();
        }
        return this._outputContainers;
    }

    public boolean isOutputEnd() {
        if (this.isAdjustHeight()) {
            return this.getMyContext().getDataCursorMemo() == -1;
        }
        return true;
    }

    public void relive() {
        this.getMyContext().requestRelive();
    }

    public void secondBirth() {
        this.getMyContext().requestSecondBirth();
    }
}

